package spotify;

import java.io.File;
import java.net.URL;

import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Clip;

public class MP3 {
    String filePath;
    public MP3(String musicPath){
        String fn = "Music/";
        URL url = getClass().getClassLoader().getResource(fn);
        assert url != null;
        String path = url.toString().substring(6)+"/"+musicPath;
        filePath = path;
    }

    public void displayMusic(){
      
        File music = new File(new File(filePath).getAbsolutePath());
        try {
            AudioInputStream audios = AudioSystem.getAudioInputStream(music);
            Clip clip = AudioSystem.getClip();
            clip.open(audios);
            
            clip.start();
            clip.loop(Clip.LOOP_CONTINUOUSLY);
            
        } catch (Exception e) {
            System.out.println("Error with playing sound.");
            e.printStackTrace();
        }
        
        
    }
}
