package map;


import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;

import entity.Bat;
import entity.Monster;
import environnement.Coordonnees;
import environnement.HitBox;
import jeu.Jeu;
import loaders.LoadSave;


public class LevelManager {


	private BufferedImage[] levelSprite;
	private Level levelOne;

	public LevelManager() {
		importOutsideSprites();
		levelOne = new Level(LoadSave.GetLevelData());
	}

	private void importOutsideSprites() {
		BufferedImage img = LoadSave.GetSpriteAtlas(LoadSave.LEVEL_SPRITES);
		levelSprite = new BufferedImage[7];

		//Pour les sprites de chaque bloc
		levelSprite[0] = img.getSubimage(0, 0, 32, 192);
		levelSprite[1] = img.getSubimage( 32,  0, 32, 96);
		levelSprite[2] = img.getSubimage(2 * 32, 0, 32, 64);
		levelSprite[3] = img.getSubimage(3 * 32, 0, 64, 32);
		levelSprite[4] = img.getSubimage(5 * 32, 0, 96, 32);
		levelSprite[5] = img.getSubimage(3 * 32, 32, 32, 32);
		levelSprite[6] = img.getSubimage(32, 3 * 32, 224, 32);
		/*for (int j = 0; j < 2; j++)
			for (int i = 0; i < 9; i++) {
				int index = j * 9 + i;
				levelSprite[index] = img.getSubimage(i * 32, j * 32, 32, 32);
			}*/
	}

	public List<Obstacle> generateObstacleTable() {
		List<Obstacle> obstacleList = new ArrayList<>();
		for (int j = 0; j < Jeu.TILES_IN_HEIGHT; j++){
			for (int i = 0; i < Jeu.TILES_IN_WIDTH; i++) {
				int index = levelOne.getSpriteIndex(i, j);

				//Index selon la couleur associée au bloc
				if (index==0) {
					obstacleList.add(new Obstacle(new HitBox(new Coordonnees(Jeu.TILES_SIZE * i+Jeu.TILES_SIZE/2, Jeu.TILES_SIZE * j-6*Jeu.TILES_SIZE/2), 6*Jeu.TILES_SIZE, 1*Jeu.TILES_SIZE)));

				}
				if (index==1) {
					obstacleList.add(new Obstacle(new HitBox(new Coordonnees(Jeu.TILES_SIZE * i+Jeu.TILES_SIZE/2, Jeu.TILES_SIZE * j-3*Jeu.TILES_SIZE/2), 3*Jeu.TILES_SIZE, 1*Jeu.TILES_SIZE)));

				}
				if (index==2) {
					obstacleList.add(new Obstacle(new HitBox(new Coordonnees(Jeu.TILES_SIZE * i+Jeu.TILES_SIZE/2, Jeu.TILES_SIZE * j-2*Jeu.TILES_SIZE/2), 2*Jeu.TILES_SIZE, 1*Jeu.TILES_SIZE)));

				}
				if (index==3) {
					obstacleList.add(new Obstacle(new HitBox(new Coordonnees(Jeu.TILES_SIZE * i+2*Jeu.TILES_SIZE/2, Jeu.TILES_SIZE * j-Jeu.TILES_SIZE/2), 1*Jeu.TILES_SIZE, 2*Jeu.TILES_SIZE)));

				}
				if (index==5) {
					obstacleList.add(new Obstacle(new HitBox(new Coordonnees(Jeu.TILES_SIZE * i+3*Jeu.TILES_SIZE/2, Jeu.TILES_SIZE * j-Jeu.TILES_SIZE/2), 1*Jeu.TILES_SIZE, 3*Jeu.TILES_SIZE)));

				}

			}
		}return obstacleList;
	}
	public List<Monster> generateMonsterTable() {
		List<Monster> monsterList = new ArrayList<>();
		for (int j = 0; j < Jeu.TILES_IN_HEIGHT; j++){
			for (int i = 0; i < Jeu.TILES_IN_WIDTH; i++) {
				int index = levelOne.getSpriteIndex(i, j);

				if (index == 13) {
					monsterList.add(new Monster(new Coordonnees(32 * i + 30 / 2, 32 * j - 62 / 2), 1000, 30, 60, 1, 5));

				}
				//chauve-souris
				if (index == 14) {
					monsterList.add(new Bat(new Coordonnees(32 * i + 20 / 2, 32 * j - 30 / 2), 1, 3));

				}
			}
		}return monsterList;
	}

	public List<Coffre> generateCoffreTable(){
		List<Coffre> coffreListe = new ArrayList<>();
		
		for (int j = 0; j < Jeu.TILES_IN_HEIGHT; j++){
			for (int i = 0; i < Jeu.TILES_IN_WIDTH; i++) {
				int index = levelOne.getSpriteIndex(i, j);
				//Coffres
				if (index==11) {
					coffreListe.add(new Coffre(new HitBox(new Coordonnees(Jeu.TILES_SIZE * i+Jeu.TILES_SIZE/2, Jeu.TILES_SIZE * j-Jeu.TILES_SIZE/2), Jeu.TILES_SIZE, Jeu.TILES_SIZE)));

				}
				if (index==25) {
					coffreListe.add(new Coffre(new HitBox(new Coordonnees(Jeu.TILES_SIZE * i+7*Jeu.TILES_SIZE/2, Jeu.TILES_SIZE * j-Jeu.TILES_SIZE/2), 1*Jeu.TILES_SIZE, 7*Jeu.TILES_SIZE)));

				}
			}
		}
		return coffreListe;
	}


	public void update() {

	}

	public Level getCurrentLevel() {
		return levelOne;
	} 

}
