package loaders;

import entity.Character;
import java.awt.Image;
import java.util.Map;
import java.util.HashMap;

import javax.swing.ImageIcon;

public class CharacterLoader { // classe qui cree le perso
    private Character gameCharacter; // perso a creer
    private String skinPath; // chemin du skin a l'instant t du jeu
    private Image imageCharacter;
    private Map<String,Integer> pathTable; // objet utilise a revoir

    public CharacterLoader(String path,Character charac){
        gameCharacter = charac;
        skinPath = path;
        imageCharacter = new ImageIcon(path).getImage();
        pathTable = new HashMap<String,Integer>();
        
    }

    public void refreshImage(){
        imageCharacter = new ImageIcon(skinPath).getImage();
        
    }

    public Character getGameCharacter() {
        return gameCharacter;
    }

    public String getSkinPath() {
        return skinPath;
    }

    public Image getImageCharacter() {
        return imageCharacter;
    }

    public void setSkinPath(String skinPath) {
        this.skinPath = skinPath;
    }

    public Map<String, Integer> getPathTable() {
        return pathTable;
    }

    public void setPathTable(Map<String, Integer> pathTable) {
        this.pathTable = pathTable;
    }

    
}
