package entity;

import java.util.List;

import environnement.Coordonnees;
import jeu.Jeu;

public class ShootingCharacter extends Character{

    private int hasAttacked = 0; //varialbe disant si il a deja attaque, il ne peut attaque que toutes les deux frames, ainsi il ne peut attaquer que si = 0
    public ShootingCharacter(Coordonnees c, double vitesseMax, double m, double impSaut){
        super(c, vitesseMax, m, impSaut);
    }

    public void attaque(){
        if (this.getTableCommande().get("CommandAttack") != 0 && hasAttacked == 0){ //on ajoute un kunai dans la liste
            List<Kunai> temp = Jeu.getKunaiList();
            Coordonnees coordKunai = new Coordonnees(coord.getX()+direction*Kunai.getWidth()/2+direction*this.getEntityWIDTH()/2, coord.getZ());
            temp.add(new Kunai(direction, attackStat, coordKunai));
            Jeu.setKunaiList(temp);
            hasAttacked++;
        }
    }

    public void evolveCharacter(){
        super.evolveCharacter();
        if (hasAttacked > 0){
            hasAttacked++;
            if (hasAttacked > 50)hasAttacked = 0; 
        }
    }
}
