package entity;

import java.util.List;

import environnement.Coordonnees;
import environnement.HitBox;
import static jeu.Jeu.getMonsterList;

public class Kunai {
    private final int direction; //1 si vers la droite, -1 si vers la gauche
    private final int damage;
    private final double vitesse = 5;
    private HitBox hitBox;
    private Coordonnees coord;
    private final Coordonnees coordInit; //coordonnees initiales
    private boolean disappear = false; //variable disant si le kunai doit disparaitre ou non
    private static final int height = 12;
    private static final int width = 24;

    public Kunai(int dir,int dmg,Coordonnees c){
        coord = c;
        coordInit = coord;
        damage = dmg;
        direction = dir;
        hitBox = new HitBox(coord,height,width);
    }

    private void deplacement(){ //deplacement du kunai
        double newX = coord.getX() + direction*vitesse;
        this.coord = new Coordonnees(newX, this.coord.getZ());
    }

    private void updateHitBox(){ //on update la hitbox du kunai
        hitBox = new HitBox(coord,height,width);
    }

    private void dealsDamage(Entity entity){
        if (HitBox.collision(hitBox, entity.getHitBox())){
            if (entity.nbFramesInvincible == 0){
                entity.setNbLifePoints(Math.max(entity.getNbLifePoints()-damage,0));
                entity.nbFramesInvincible = entity.nbMaxFramesInvicible;//l'entity devient invincible qq frames
            }
            disappear = true; //disparait apres choc avec un monstre
        }
    }

    private void evolveKunai(){
        deplacement();
        updateHitBox();
        for (Monster monster : getMonsterList()){
            dealsDamage(monster);
            if (disappear)break; //si le kunai a disparu on arrete de regarder les autres monstres

        }
        if (Math.abs(coordInit.getX()-coord.getX()) >= 500) disappear = true; //au bout d'une certaine distance parcourue, il disparait
    }

    public static void evolveAllKunais(List<Kunai> liste){
        for (Kunai kunai : liste){
            kunai.evolveKunai();
        }
        int k = 0;
        while (k < liste.size()){ //on supprime les kunais utilises
            if (liste.get(k).disappear) liste.remove(liste.get(k));
            else k++;
        }
    }

    public Coordonnees getCoord() {
        return coord;
    }

    public HitBox getHitBox() {
        return hitBox;
    }

    public static int getHeight() {
        return height;
    }

    public static int getWidth() {
        return width;
    }
    

}
