package entity;

import environnement.Coordonnees;
import environnement.HitBox;


public abstract class Entity {
    private Coordonnees coord; 
    protected Coordonnees oldCoord;
    final double vitesseMax;
    protected HitBox hitBox;
    protected int nbLifePoints = 3;
    protected final double entityWIDTH;
    protected final double entityHEIGHT;


    public int getNbLifePoints() {
        return nbLifePoints;
    }
    public void setNbLifePoints(int nbLifePoints) {
        this.nbLifePoints = nbLifePoints;
    }
    public Entity(Coordonnees c,double vitesseMax,double width,double height){
        this.coord = c;
        this.oldCoord = this.coord;
        this.vitesseMax = vitesseMax;
        this.entityHEIGHT = height;
        this.entityWIDTH = width;
        this.hitBox = new HitBox(c, entityHEIGHT, entityWIDTH);
    }
    public void deplacements(){}
    public void attaque(){}
    public Coordonnees getCoord(){
        return this.coord;
    } // Pour retourner les coordonées
    public void setCoord(Coordonnees coord) {
        this.coord = coord;
    }
    public double getEntityWIDTH() {
        return entityWIDTH;
    }
    public double getEntityHEIGHT() {
        return entityHEIGHT;
    }
    public Coordonnees getOldCoord() {
        return oldCoord;
    }
    public HitBox getHitBox() {
        return hitBox;
    }

    public void setHitBox(HitBox hitBox) {
        this.hitBox = hitBox;
    }
    public double getVitesseMax() {
        return vitesseMax;
    }


    
}
