package entity;


import java.util.HashMap;
import java.util.Map;

import environnement.Coordonnees;
import environnement.HitBox;
import environnement.Physique;
import static environnement.PositionCollision.*;
import environnement.PositionCollision;
import jeu.Jeu;
import map.Obstacle;

import static environnement.HitBox.collisionObstacle;
import static jeu.Jeu.getObstacleTable;

public class Character extends Entity{

    private double vitesseActuX = 0; // vitesse actuelle supposée nulle au départ
    private double vitesseActuZ = 0;
    private final double impulsionSaut;
    private double masse;
    private int alpha = 1; // gere les collisions avec le sol

    private Map<String,Double> tableCommande; //table des commandes du perso

    //private BufferedImage sprite;
    


    public Character(Coordonnees c, double vitesseMax, double m, double impSaut){

        super(c,vitesseMax,30,60); // comme tous les entities ont une hitbox, j'ai factorise
        this.masse = m;
        this.impulsionSaut = impSaut;
        this.setHitBox(new HitBox(c,entityHEIGHT,entityWIDTH));
        this.tableCommande = new HashMap<>();
        tableCommande.put("CommandX",(double)0);
        tableCommande.put("CommandZ",(double)0);       
    }

    @Override
    public void deplacements(){ // alpha indique si il est au sol ou non, il vaut 0 (en l'air) ou 1 (au sol) en fonction
        
        double delta = Math.pow(10, -3); // pas de temps remis en secondes

        //on actualise les positions
        double newX,newZ;
        //on se souvient de ses anciennes positions
        this.oldCoord = this.getCoord();

        newX = tableCommande.get("CommandX")*delta + this.getCoord().getX();

        
        newZ = ((1-alpha)*Physique.g - tableCommande.get("CommandZ"))/2*delta*delta + vitesseActuZ*delta + this.getCoord().getZ();
        
        if (newZ+entityHEIGHT/2 >= Jeu.getSol().getHitbox().getExtremites().get("HautGauche").getZ()){
            newZ = Jeu.getSol().getHitbox().getExtremites().get("HautGauche").getZ()-entityHEIGHT/2; //on remet sur le sol
            alpha = 1;
        }

        System.out.println(newZ-this.getCoord().getZ());

        this.setCoord(new Coordonnees(newX, newZ)); // on set les nouvelles coordonnees 
 
        //on actualise les vitesses
        vitesseActuX = tableCommande.get("CommandX");

        vitesseActuZ = vitesseActuZ + 7*((1-alpha)*Physique.g - tableCommande.get("CommandZ"))*delta;
    }

    public void collisionGestion(){
        //stocke l'obstacle avec lequel il y a eu collision
        HashMap<Obstacle,PositionCollision> collisionsPresentes = new HashMap<Obstacle,PositionCollision>();
        
        //recupere les collisions
        for (int i=0;i<getObstacleTable().size();i++) {
            collisionsPresentes.put(getObstacleTable().get(i),collisionObstacle(this.getHitBox(), getObstacleTable().get(i).getHitbox(), i));
        }

        //on set alpha a 0 (on suppose qu'il est en l'air)
        alpha = 0;

        //on parcourt pour tester si il est sur un block
        for (int i=0;i<collisionsPresentes.size();i++){
            //si on trouve on sort de la boucle (pas besoin d'aller plus loin), on n'étudie qui si on ne donne pas de commande
            if (tableCommande.get("CommandZ") != 0){
                break;
            }
            if (collisionsPresentes.get(getObstacleTable().get(i)) == BAS){           
                this.vitesseActuZ = 0;
                this.setCoord(new Coordonnees(this.getCoord().getX(), getObstacleTable().get(i).getHitbox().getExtremites().get("HautGauche").getZ()-entityHEIGHT/2));
                alpha = 1;
                break;
            }
        }

        //on gere les collisions laterales et celle du haut
        for (int i=0;i<collisionsPresentes.size();i++){
            if (collisionsPresentes.get(getObstacleTable().get(i)) == DROITE && this.vitesseActuX < 0){
                this.setCoord(new Coordonnees(getObstacleTable().get(i).getHitbox().getExtremites().get("HautDroite").getX()+entityWIDTH/2, this.getCoord().getZ()));
            }
            else if (collisionsPresentes.get(getObstacleTable().get(i)) == GAUCHE && this.vitesseActuX > 0){
                this.setCoord(new Coordonnees(getObstacleTable().get(i).getHitbox().getExtremites().get("HautGauche").getX()-entityWIDTH/2, this.getCoord().getZ()));
            }
            else if (collisionsPresentes.get(getObstacleTable().get(i)) == HAUT){
                this.vitesseActuZ = 0;
                this.setCoord(new Coordonnees(this.getCoord().getX(), getObstacleTable().get(i).getHitbox().getExtremites().get("BasGauche").getZ()+entityHEIGHT/2+1));
            }
        }

        
    }
    @Override
    public void attaque(){

    }

    public void getGameCommand(){

        Map<String,Boolean> commandeJeu = Jeu.getDirectionJeu();
        if (commandeJeu.get("Right") && commandeJeu.get("Left")){tableCommande.replace("CommandX", (double)0);}
        else if (commandeJeu.get("Right")) tableCommande.replace("CommandX", vitesseMax);
        else if (commandeJeu.get("Left")) tableCommande.replace("CommandX", -vitesseMax);

        
        if (commandeJeu.get("Jump")) {
            if ((alpha == 1) && (this.getVitesseActuZ() == 0)){
                
                tableCommande.replace("CommandZ", impulsionSaut);
                System.out.println(tableCommande.get("CommandZ"));
            }      
        }
    }


    public void resetCommand(){
        for (String key : tableCommande.keySet()){
            tableCommande.replace(key, (double)0);
        }
    }

    public void evolveCharacter(){
        getGameCommand();
        deplacements();
        collisionGestion();
        resetCommand();
        this.setHitBox(new HitBox(this.getCoord(),entityHEIGHT,entityWIDTH)); // mise à jour moins crade pour l'instant
    }

    public double getVitesseActuX() {
        return vitesseActuX;
    }

    public double getVitesseActuZ() {
        return vitesseActuZ;
    }

    public double getM() {
        return masse;
    }
    public double getImpulsionSaut() {
        return impulsionSaut;
    }

    public int getAlpha() {
        return alpha;
    }
    
}
