package environnement;

import java.util.HashMap;

public class HitBox {

    //private final Coordonnees centre;
    private HashMap<String, Coordonnees> extremites = new HashMap<>();
    private static double defaultUnit = 10;
    private double width;
    private double height;
    private Coordonnees centre;

    public double getWidth() {
        return width;
    }

    public double getHeight() {
        return height;
    }

    public Coordonnees getCentre() {
        return centre;
    }

    public HitBox(Coordonnees c){
        extremites.put("HautDroite",new Coordonnees(c.getX()+defaultUnit/2,c.getZ()-defaultUnit/2));
        extremites.put("BasDroite",new Coordonnees(c.getX()+defaultUnit/2,c.getZ()+defaultUnit/2));
        extremites.put("HautGauche",new Coordonnees(c.getX()-defaultUnit/2,c.getZ()-defaultUnit/2));
        extremites.put("BasGauche",new Coordonnees(c.getX()-defaultUnit/2,c.getZ()+defaultUnit/2));
        centre = c;
    }

    public HitBox(Coordonnees c , double Height , double Width){
        extremites.put("HautDroite",new Coordonnees(c.getX()+Width/2,c.getZ()-Height/2));
        extremites.put("BasDroite",new Coordonnees(c.getX()+Width/2,c.getZ()+Height/2));
        extremites.put("HautGauche",new Coordonnees(c.getX()-Width/2,c.getZ()-Height/2));
        extremites.put("BasGauche",new Coordonnees(c.getX()-Width/2,c.getZ()+Height/2));
        width = Width;
        height = Height;
        centre = c;
    }

    public static int getDefaultUnit() {
        return (int)defaultUnit;
    }

    public static HashMap<String,Boolean> collisionMap(HitBox A, HitBox B){ // lignes sautées pour raison de lisibilité
        HashMap<String,Boolean>  map = new HashMap<>();
        map.put("collision_gauche", false);
        map.put("collision_droite", false);
        map.put("collision_bas", false);
        map.put("collision_haut", false);
        boolean a = !(A.extremites.get("HautGauche").getX() > B.extremites.get("HautDroite").getX()); // A est à droite de B
        boolean b = !(A.extremites.get("HautDroite").getX() < B.extremites.get("HautGauche").getX()); // A est à gauche de B
        boolean c = !(A.extremites.get("HautGauche").getZ() > B.extremites.get("BasGauche").getZ()); // A est en dessous de B
        boolean d = !(A.extremites.get("BasGauche").getZ() < B.extremites.get("HautGauche").getZ()); // A est au dessus de B
        if (a && !d && !c){
            map.put("collision_gauche", true);
        }
        else if (b && !d && !c) {
            map.put("collision_droite", true);
        }
        else if (c && !a && !b) {
            map.put("collision_bas", true );
        }
        else if (d && !a && !b) {
            map.put("collision_haut", true);
        }
        return map;
    }

    public static Boolean collision(HitBox A, HitBox B){
        Boolean a = !(A.extremites.get("HautGauche").getX() > B.extremites.get("HautDroite").getX()); // A est à droite de B
        Boolean b = !(A.extremites.get("HautDroite").getX() < B.extremites.get("HautGauche").getX()); // A est à gauche de B
        Boolean c = !(A.extremites.get("HautGauche").getZ() > B.extremites.get("BasGauche").getZ()); // A est en dessous de B
        Boolean d = !(A.extremites.get("BasGauche").getZ() < B.extremites.get("HautGauche").getZ()); // A est au dessus de B
        return a && b && c && d;
    }
    public HashMap<String, Coordonnees> getExtremites() {
        return extremites;
    }
}