package entity;

import environnement.Coordonnees;
//import environnement.Physique;
import environnement.Physique;
import environnement.PositionCollision;
import static environnement.PositionCollision.*;
import map.Obstacle;

import static jeu.Jeu.getObstacleTable;

import java.util.HashMap;
import java.util.List;

public class Boss extends Monster{

    private int impulsionSaut = 0;

    public Boss(Coordonnees c, double vitesseMax,double width,double height,int atkStt,int nbLP){
        super(c, vitesseMax, width, height, atkStt, nbLP);
    }

    public void deplacements(){
        double delta = Math.pow(10, -3);
        int nbRand = (int)(200*(Math.random()));//on cree une loi de bernouilli de parametre 1/200
        if (nbRand == 0 && alpha == 1){ //une chance sur 5 de sauter et ne saute que si au sol (alpha == 1)
            impulsionSaut = 700000;
        }
        //on se souvient de ses anciennes positions
        oldCoord = coord;

        //pour faire un deplacement cyclique
        if ((coordInit.getX()-coord.getX() >= 500 && direction == -1) || coord.getX() <= obstacleBeneath.getHitbox().getExtremites().get("HautGauche").getX())direction = 1;
        else if ((coordInit.getX()-coord.getX() <= -500 && direction == 1) || coord.getX() >= obstacleBeneath.getHitbox().getExtremites().get("HautDroite").getX())direction = -1;
        //******************

        double newX = coord.getX() + (1-Math.min(isAttacking,1))*direction*vitesseMax*delta;
        
        double newZ = (1-alpha)*Physique.g/2*delta*delta + this.vitesseActuZ*delta + this.getCoord().getZ();
        vitesseActuZ = vitesseActuZ + 8*(1-alpha)*Physique.g*delta;
        
        if (impulsionSaut != 0){
            
            newZ = newZ - impulsionSaut/2*delta*delta;
            vitesseActuZ = vitesseActuZ - 8*impulsionSaut*delta;
        }

        
        
        
        
        setCoord(new Coordonnees(newX, newZ));
        
    }

    public void collisionGestion(){
        List<Obstacle> listeObstaclesInVoisinage = getObstacleTable();
        //stocke l'obstacle avec lequel il y a eu collision
        HashMap<Obstacle,PositionCollision> collisionsPresentes = new HashMap<Obstacle,PositionCollision>();
        
        //recupere les collisions
        for (int i=0;i<listeObstaclesInVoisinage.size();i++) {
            PositionCollision posCol = Obstacle.collision(this, listeObstaclesInVoisinage.get(i), i);
            
            collisionsPresentes.put(listeObstaclesInVoisinage.get(i),posCol);
        }

        

        //on gere celles du bas
        //on set alpha a 0 (on suppose qu'il est en l'air)
        alpha = 0;

            //on parcourt pour tester si il est sur un block
            for (int i=0;i<collisionsPresentes.size();i++){
                //si on trouve on sort de la boucle (pas besoin d'aller plus loin), on n'étudie qui si on ne donne pas de commande
                if (impulsionSaut != 0){
                    break;
                }
                if (collisionsPresentes.get(listeObstaclesInVoisinage.get(i)) == BAS){
                    this.vitesseActuZ = 0;
                    this.setCoord(new Coordonnees(this.getCoord().getX(), getObstacleTable().get(i).getHitbox().getExtremites().get("HautGauche").getZ()-entityHEIGHT/2));
                    alpha = 1;

                    break;
                }
            }
            /*for (Obstacle obs : listeObstaclesInVoisinage){ //on cherche l'obstacle en-dessous du perso
                if (obs.getHitbox().getExtremites().get("HautGauche").getZ() <= obstacleBeneath.getHitbox().getExtremites().get("HautGauche").getZ() && obs.getHitbox().getExtremites().get("HautGauche").getZ() >= hitBox.getExtremites().get("BasDroite").getZ()){
                    obstacleBeneath = obs;
                }
            }
            
            if (collisionsPresentes.get(obstacleBeneath) == BAS && tableCommande.get("CommandAttack") == 0){
                this.vitesseActuZ = 0;
                    this.setCoord(new Coordonnees(this.getCoord().getX(), obstacleBeneath.getHitbox().getExtremites().get("HautGauche").getZ()-entityHEIGHT/2-1));
                    alpha = 1;
                    onGround = true;
            }*/


        //}
        //on gere les collisions laterales et celle du haut
        for (int i=0;i<collisionsPresentes.size();i++){

            if (collisionsPresentes.get(listeObstaclesInVoisinage.get(i)) == DROITE && this.direction == -1){
                this.setCoord(new Coordonnees(listeObstaclesInVoisinage.get(i).getHitbox().getExtremites().get("HautDroite").getX()+entityWIDTH/2, this.getCoord().getZ()));
                break;
            }

            else if (collisionsPresentes.get(listeObstaclesInVoisinage.get(i)) == GAUCHE && this.direction == 1){
                this.setCoord(new Coordonnees(listeObstaclesInVoisinage.get(i).getHitbox().getExtremites().get("HautGauche").getX()-entityWIDTH/2, this.getCoord().getZ()));
                break;
            }

        }
        
        //on gere celles du haut
        for (int i=0;i<collisionsPresentes.size();i++){
            if (collisionsPresentes.get(listeObstaclesInVoisinage.get(i)) == HAUT){
                this.vitesseActuZ = 0;
                this.setCoord(new Coordonnees(this.getCoord().getX(), listeObstaclesInVoisinage.get(i).getHitbox().getExtremites().get("BasGauche").getZ()+entityHEIGHT/2+1));
                break;
            }
        }    
    }

    public void evolveMonster(){
        super.evolveMonster();
        impulsionSaut = 0;
    }
    
}
