package entity;

import static org.junit.Assert.assertFalse;
import static org.junit.Assert.assertNotEquals;
import static org.junit.Assert.assertTrue;

import org.junit.BeforeClass;
import org.junit.Test;

import environnement.Coordonnees;
import environnement.HitBox;
import jeu.Jeu;
import map.Coffre;
import map.LevelManager;
import map.Obstacle;

public class CharacterTest {

    static Character character;
    static Obstacle obstacleTest;
    static Monster monster;
    static Coffre coffreTest;

    @BeforeClass
    public static void generateParameters(){
        character = new Character(new Coordonnees(2,3), 100, 1, 50000);
        obstacleTest = new Obstacle(new HitBox(new Coordonnees(10, 30),50,60));
        monster = new Monster(new Coordonnees(20, 3), 100, 50, 60, 1, 1);
        Jeu.getMonsterList().add(monster);
        character.tableCommande.put("CommandX",(double) 1000);
        character.tableCommande.put("CommandZ",(double) 1000000);
        character.tableCommande.put("CommandAttack", (double) 1);
    }
    @Test
    public void testAttaque() {
        character.attaque();
        assertTrue("monstre mort", monster.death());
    }

    @Test
    public void testCollisionGestion() {
        assertTrue("y a collision avec l obstacle", HitBox.collision(character.hitBox, obstacleTest.getHitbox()));

        
    }

    @Test
    public void testDeplacements() {
        double x = character.getCoord().getX();
        double z = character.getCoord().getZ();
        character.deplacements();
        assertNotEquals(x, character.getCoord().getX());
        assertNotEquals(z, character.getCoord().getZ());
    }


    /*@Test
    public void testKeyGestion() {
        assertTrue("il a pas de cle", character.key==0);

        character.keyGestion();
        assertTrue("il a une cle", character.key==1);
    }*/

    @Test
    public void testResetCommand() {
        assertFalse("commandes non nulles", character.tableCommande.get("CommandX")==0 && character.tableCommande.get("CommandZ")==0 && character.tableCommande.get("CommandAttack")==0);
        character.resetCommand();
        assertTrue("commandes non nulles", character.tableCommande.get("CommandX")==0 && character.tableCommande.get("CommandZ")==0 && character.tableCommande.get("CommandAttack")==0);

    }
}
