package jeu;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;

import entity.Character;
import engine.Game;
import environnement.Coordonnees;
import loaders.CharacterLoader;


public class Jeu implements Game{

    private static Coordonnees coordSol = new Coordonnees(200,700); //coordonnees du sol (en realite juste Z nous interesse)
    static Character gameCharacter;
    private static Map<String,Boolean> directionJeu;
    static CharacterLoader gameCharacterLoader;
    String characterSkinPath; // jsp si c'est le jeu qui doit gerer ca, au pire vous pouvez changer
    final String beginPath;
    String movement;
    int numberOfMovement;
    int nbIterationPerFrame = 100;
    int nbBeforeFramechgt = nbIterationPerFrame;
    

    public Jeu(String source) {

        BufferedReader helpReader;
        beginPath = Paths.get(".").toAbsolutePath().normalize() + "\\src\\main\\resources\\Frames_perso\\"; // met ce que tu veux pour pas avoir de pb et pour les tests
        movement = "Character_idle";
        numberOfMovement = 1;
        characterSkinPath = beginPath + movement + Integer.toString(numberOfMovement) + ".png"; // path premiere frame
        /*A = new ArrayList<Double>();
        n = 0;*/
        gameCharacterLoader = new CharacterLoader(characterSkinPath,new Character(new Coordonnees(200, 300), 2000, 1,600000));
        gameCharacter = gameCharacterLoader.getGameCharacter();
        try {
            helpReader = new BufferedReader(new FileReader(source));
            String line;
            while ((line = helpReader.readLine()) != null) {
                System.out.println(line);
            }
            helpReader.close();
        } catch (IOException e) {
            System.out.println("Help not available");
        }

        directionJeu = new HashMap<String,Boolean>();
        directionJeu.put("Right", false);
        directionJeu.put("Left", false);
        directionJeu.put("Jump", false);
        
    }

    @Override
    public void evolve(HashMap<String,Boolean> command) {  // command est sous la forme list de Boolean qui represente les touches préssées. Voir Controller pour la compositions de cet list.
        /*System.out.println("Execute "+command);
        System.out.println(gameCharacter.getCoord().getX());
        System.out.println(gameCharacter.getCoord().getZ());*/
        /*double comX,comZ;
        int a = 1;
        
        comX = 0;
        comZ = 0;*/

        directionJeu.replace("Right", command.get("Right"));
        directionJeu.replace("Left", command.get("Left"));
        directionJeu.replace("Jump", command.get("Jump"));
        /*Boolean Right = command.get("Right");
        boolean Left = command.get("Left");
        boolean Jump = command.get("Jump");

        if (Right && Left){}
        else if (Right) {
            comX = gameCharacter.getVitesseMax();
        }
        else if (Left) {
            comX = -gameCharacter.getVitesseMax();
        }
        if (Jump) {
            if (gameCharacter.getCoord().getZ() < coordSol.getZ())a = 0;
        else if (gameCharacter.getVitesseActuZ() == 0){comZ = gameCharacter.getImpulsionSaut();/*A.add(gameCharacter.getCoord().getZ());n++;/}
        }
        else {
            if (gameCharacter.getCoord().getZ() < coordSol.getZ()) { //a retoucher, j'ai besoin d'autres choses pour avancer
                a = 0; 
            }
            else{
                a = 1;
            }
        
        }*/

        gameCharacter.evolveCharacter();
        if ((nbIterationPerFrame-nbBeforeFramechgt) == nbIterationPerFrame) { // timer pour changer de frame
            numberOfMovement = numberOfMovement%2 + 1;
            nbBeforeFramechgt = nbIterationPerFrame;
        }
        else nbBeforeFramechgt--;
        characterSkinPath = beginPath + movement + Integer.toString(numberOfMovement) + ".png";
        gameCharacterLoader.setSkinPath(characterSkinPath);
        gameCharacterLoader.refreshImage();
        
    }

    @Override
    public boolean isFinished() {
        // le jeu n'est jamais fini
        /*if (n >= 10){
            System.out.println(A.toString());
            return true;
        }*/
        return false;
    }

    public static Coordonnees getCoordSol(){
        return coordSol;
    }

    public static Map<String, Boolean> getDirectionJeu() {
        return directionJeu;
    }
    
}