package jeu;

import engine.GamePainter;
import entity.Character;
import environnement.Obstacle;

import java.awt.*;
import java.awt.image.BufferedImage;


import static environnement.HitBox.getDefaultUnit;
import static jeu.Jeu.gameCharacter;
import static jeu.Jeu.gameCharacterLoader;
import static jeu.Jeu.getCoordSol;

public class Painter implements GamePainter{

    protected static final int WIDTH = 1000;
    protected static final int HEIGHT = 1000;

    public Painter() {
        
    }

    @Override
    public void draw(BufferedImage im) {
        Graphics2D crayon = (Graphics2D) im.getGraphics();
        crayon.setColor(Color.blue);
        drawCharacter(crayon, gameCharacter,gameCharacterLoader.getImageCharacter());
        drawSol(crayon);
        crayon.setColor(Color.red);
        //drawQuadrillage(crayon);
    }

    @Override
    public int getWidth() {
        return WIDTH;
    }

    @Override
    public int getHeight() {
        return HEIGHT;
    }

    private void drawCharacter(Graphics2D crayon, Character charac,Image imageCharac){
        int x = (int) gameCharacter.getCoord().getX();
        int y = (int) gameCharacter.getCoord().getZ();
        //crayon.fillRect(x-15,y-30, (int) gameCharacter.getEntityWIDTH(),(int) gameCharacter.getEntityHEIGHT());
        crayon.drawImage(imageCharac, x-30, y-60, null, null);

    }

    private void drawObstacle(Graphics2D crayon, Obstacle obstacle){

    }

    private void drawSol(Graphics2D crayon){
        crayon.drawLine(0,(int) getCoordSol().getZ(),WIDTH,(int) getCoordSol().getZ());
    }

    private void drawQuadrillage(Graphics2D crayon){ //pour le test de la classe obstacle
        int taille = getDefaultUnit();
        for (int i=1;i<(double) HEIGHT/taille;i++) {
            crayon.drawLine(0, i * taille, WIDTH, i * taille);
        }
        for (int j =0;j<(double) WIDTH/taille;j++) {
            crayon.drawLine(j * taille, 0, j * taille,HEIGHT );
        }
    }
}
