package jeu;

import engine.GameController;

import java.awt.event.KeyEvent;
import java.util.HashMap;

public class Controller implements GameController{

    private boolean isRightPressed, isLeftPressed, isSpacePressed;
    private HashMap<String,Boolean> cmd = new HashMap<String,Boolean>();
    /*
    * commande en cours
    */

    /*
    * construction du controleur par defaut le controleur n'a pas de commande
    */

    public Controller() {
        isRightPressed = false; isLeftPressed = false; isSpacePressed = false;
    }
    /**
     * getCommand retourne une liste de booleans sous la forme [isRightPressed, isLeftPressed, isSpacePressed]
     */
    @Override
    public HashMap<String,Boolean> getCommand() {
        cmd.put("Right",isRightPressed);
        cmd.put("Left",isLeftPressed);
        cmd.put("Jump",isSpacePressed);
        return cmd;
    }
    @Override

    public void keyPressed(KeyEvent e) {

        switch (e.getKeyCode()) {
            // si on appuie sur une touche ci dessous le boolean devient vraie.
            case KeyEvent.VK_RIGHT -> isRightPressed = true;
            case KeyEvent.VK_LEFT -> isLeftPressed = true;
            case KeyEvent.VK_SPACE -> isSpacePressed = true;
        }
    }
    @Override
    public void keyReleased(KeyEvent e) {
        switch (e.getKeyCode()) {
            case KeyEvent.VK_RIGHT -> isRightPressed = false;
            case KeyEvent.VK_LEFT -> isLeftPressed = false;
            case KeyEvent.VK_SPACE -> isSpacePressed = false;
        }
    }
    @Override

    public void keyTyped(KeyEvent e) {

    }

}