package environnement;

import java.util.HashMap;
import java.util.List;

import static environnement.PositionCollision.*;
import static jeu.Jeu.getObstacleTableCollisionCharac;
import static jeu.Jeu.setObstacleTableCollisionCharac;

public class HitBox {

    //private final Coordonnees centre;
    private HashMap<String, Coordonnees> extremites = new HashMap<>();
    private static double defaultUnit = 10;
    private double width;
    private double height;
    private Coordonnees centre;

    public double getWidth() {
        return width;
    }

    public double getHeight() {
        return height;
    }

    public Coordonnees getCentre() {
        return centre;
    }

    public HitBox(Coordonnees c){
        extremites.put("HautDroite",new Coordonnees(c.getX()+defaultUnit/2,c.getZ()-defaultUnit/2));
        extremites.put("BasDroite",new Coordonnees(c.getX()+defaultUnit/2,c.getZ()+defaultUnit/2));
        extremites.put("HautGauche",new Coordonnees(c.getX()-defaultUnit/2,c.getZ()-defaultUnit/2));
        extremites.put("BasGauche",new Coordonnees(c.getX()-defaultUnit/2,c.getZ()+defaultUnit/2));
        centre = c;
    }

    public HitBox(Coordonnees c , double Height , double Width){
        extremites.put("HautDroite",new Coordonnees(c.getX()+Width/2,c.getZ()-Height/2));
        extremites.put("BasDroite",new Coordonnees(c.getX()+Width/2,c.getZ()+Height/2));
        extremites.put("HautGauche",new Coordonnees(c.getX()-Width/2,c.getZ()-Height/2));
        extremites.put("BasGauche",new Coordonnees(c.getX()-Width/2,c.getZ()+Height/2));
        width = Width;
        height = Height;
        centre = c;
    }

    public static int getDefaultUnit() {
        return (int)defaultUnit;
    }

    public static Boolean collision(HitBox A, HitBox B){
        Boolean a = !(A.extremites.get("HautGauche").getX() > B.extremites.get("HautDroite").getX()); // A est à droite de B
        Boolean b = !(A.extremites.get("HautDroite").getX() < B.extremites.get("HautGauche").getX()); // A est à gauche de B
        Boolean c = !(A.extremites.get("HautGauche").getZ() > B.extremites.get("BasGauche").getZ()); // A est en dessous de B
        Boolean d = !(A.extremites.get("BasGauche").getZ() < B.extremites.get("HautGauche").getZ()); // A est au dessus de B
        return a && b && c && d;
    }
    public HashMap<String, Coordonnees> getExtremites() {
        return extremites;
    }

    public static PositionCollision collisionObstacle(HitBox A, HitBox B,int i) {
        List<PositionCollision> L = getObstacleTableCollisionCharac();
        boolean a = !(A.getExtremites().get("HautGauche").getX() > B.getExtremites().get("HautDroite").getX()); // A est à droite de B
        boolean b = !(A.getExtremites().get("HautDroite").getX() < B.getExtremites().get("HautGauche").getX()); // A est à gauche de B
        boolean c = !(A.getExtremites().get("HautGauche").getZ() > B.getExtremites().get("BasGauche").getZ()); // A est en dessous de B
        boolean d = !(A.getExtremites().get("BasGauche").getZ() < B.getExtremites().get("HautGauche").getZ()); // A est au-dessus de B

        int somme = 0;
        if (a) {
            somme++;
        }
        if (b) {
            somme++;
        }
        if (c) {
            somme++;
        }
        if (d) {
            somme++;
        }

        if (somme == 3) {
            if (!a) {
                L.set(i, DROITE);
            }
            if (!b) {
                L.set(i, GAUCHE);
            }
            if (!c) {
                L.set(i, HAUT);
            }
            if (!d) {
                L.set(i, BAS);
            }
            setObstacleTableCollisionCharac(L);
        }

        if (somme == 4) {
            return L.get(i);
        } else {
            return NONE;
        }
    }

    @Override
    public String toString() {
        return "Hitbox ";
    }
}