package entity;

import environnement.Coordonnees;
import environnement.HitBox;
import static jeu.Jeu.getGameCharacter;

import java.util.List;

public class Monster extends Entity{

    int direction = -1; // direction selon l'axe des x, -1 pour la gauche et 1 pour la droite

    public Monster(Coordonnees c, double vitesseMax,double width,double height,int atkStt,int nbLP) {
        super(c, vitesseMax,width,height,atkStt);
        maxLifePoints = nbLP;
        nbLifePoints = maxLifePoints;
    }

    public void deplacements(){
        double delta = Math.pow(10, -3);

        //on se souvient de ses anciennes positions
        oldCoord = coord;

        //temporaire, pour faire un deplacement cyclique
        if (coord.getX() < 0)direction = 1;
        else if (coord.getX() >= 1000)direction = -1;
        //******************

        double newX = coord.getX()+direction*vitesseMax*delta;
        setCoord(new Coordonnees(newX, coord.getZ()));
    }
    
    public void attaque(){
        if (HitBox.collision(this.hitBox, getGameCharacter().getHitBox())){
            //le Math.max est la juste pour que la vie du perso ne tombe pas en-dessous de zero
            getGameCharacter().setNbLifePoints(Math.max(getGameCharacter().getNbLifePoints()-attackStat,0));
        }
    }

    public void evolveMonster(){ //evolution du monstre
        deplacements();
        attaque();
        this.setHitBox(new HitBox(this.getCoord(),entityHEIGHT,entityWIDTH));
        
    }

    public static void evolveAllMonsters(List<Monster> liste){ // evolution de tous les monstres
        if (!liste.isEmpty()){
            for (Monster monster : liste)monster.evolveMonster();
        }
        int i = 0;
        while (i < liste.size()){
            if (liste.get(i).death())liste.remove(i);
            else i++;
        }

    }

    public Boolean death(){
        return nbLifePoints == 0;
    }
    
}
