package environnement;

import java.util.HashMap;

public class HitBox {
    //private final Coordonnees centre;
    private HashMap<String, Coordonnees> extremites = new HashMap<String,Coordonnees>();
    private static double defaultUnit = 10;

    public HitBox(Coordonnees c){
        extremites.put("HautDroite",new Coordonnees(c.getX()+defaultUnit/2,c.getZ()-defaultUnit/2));
        extremites.put("BasDroite",new Coordonnees(c.getX()+defaultUnit/2,c.getZ()+defaultUnit/2));
        extremites.put("HautGauche",new Coordonnees(c.getX()-defaultUnit/2,c.getZ()-defaultUnit/2));
        extremites.put("BasGauche",new Coordonnees(c.getX()-defaultUnit/2,c.getZ()+defaultUnit/2));
    }

    public HitBox(Coordonnees c , double Height , double Width){
        extremites.put("HautDroite",new Coordonnees(c.getX()+Width/2,c.getZ()-Height/2));
        extremites.put("BasDroite",new Coordonnees(c.getX()+Width/2,c.getZ()+Height/2));
        extremites.put("HautGauche",new Coordonnees(c.getX()-Width/2,c.getZ()-Height/2));
        extremites.put("BasGauche",new Coordonnees(c.getX()-Width/2,c.getZ()+Height/2));
    }

    public static int getDefaultUnit() {
        return (int)defaultUnit;
    }

    public static Boolean Collision(HitBox A, HitBox B){ // lignes sautées pour raison de lisibilité
        return A.extremites.get("HautDroite").getX() >= B.extremites.get("BasGauche").getX()
                && A.extremites.get("HautDroite").getZ() <= B.extremites.get("BasGauche").getZ()
                ||
                A.extremites.get("BasDroite").getX() >= B.extremites.get("HautGauche").getX()
                        && A.extremites.get("BasDroite").getZ() >= B.extremites.get("HautGauche").getZ()
                ||
                A.extremites.get("HautGauche").getX() <= B.extremites.get("BasDroite").getX()
                        && A.extremites.get("HautGauche").getZ() <= B.extremites.get("BasDroite").getZ()
                ||
                A.extremites.get("BasGauche").getX() <= B.extremites.get("HautDroite").getX()
                        && A.extremites.get("BasGauche").getZ() >= B.extremites.get("HautDroite").getZ();
    }
}
