package entity;

import java.util.HashMap;
import java.util.Map;

import environnement.Coordonnees;
import environnement.HitBox;
import environnement.Physique;
import jeu.Jeu;


public class Character extends Entity{

    private double vitesseActuX = 0; // vitesse actuelle supposée nulle au départ
    private double vitesseActuZ = 0;
    private final double impulsionSaut;
    private double masse;
    private int alpha = 1; // gere les collisions avec le sol
    private final double characterWIDTH = 30; // pour l'instant je les ai renommes, ca peut changer
    private final double characterHEIGHT= 60;
    private Map<String,Double> tableCommande; //table des commandes du perso
    //private BufferedImage sprite;


    public Character(Coordonnees c,double vitesseMax,double m,double impSaut){
        super(c,vitesseMax,null); // comme tous les entities ont une hitbox, j'ai factorise
        this.masse = m;
        this.impulsionSaut = impSaut;
        this.hitBox = new HitBox(c,characterHEIGHT,characterWIDTH);
        this.tableCommande = new HashMap<String,Double>();
        tableCommande.put("CommandX",(double)0);
        tableCommande.put("CommandZ",(double)0);
        //sprite = CharacterLoader.getImageCharacter();
        
    }
    @Override
    public void deplacements(){ // alpha indique si il est au sol ou non, il vaut 0 ou 1 en fonction
        getGameCommand();
        double delta = Math.pow(10, -3); // pas de temps remis en secondes

        //on actualise les positions
        double newX,newZ;

        newX =  tableCommande.get("CommandX")*delta + this.getCoord().getX(); // frottements enleves (le perso finissait par freiner tout seul donc tant que y'a pas d'interet je les enleve, j'ai tjr les equations de cote)

        if ((tableCommande.get("CommandZ") == 0) && (this.getCoord().getZ() >= Jeu.getCoordSol().getZ()))newZ = Jeu.getCoordSol().getZ();
        else newZ = ((1-alpha)*Physique.g - tableCommande.get("CommandZ"))/2*delta*delta + vitesseActuZ*delta + this.getCoord().getZ();

        //System.out.println("écart de hauteur: "+Math.abs(this.getCoord().getZ()-newZ));

        this.setCoord(new Coordonnees(newX, newZ)); // on set les nouvelles coordonnees

        //on actualise les vitesses
        vitesseActuX = tableCommande.get("CommandX");

        if ((tableCommande.get("CommandZ") == 0) && (this.getCoord().getZ() >= Jeu.getCoordSol().getZ())) vitesseActuZ = 0;
        else vitesseActuZ = vitesseActuZ + 7*((1-alpha)*Physique.g - tableCommande.get("CommandZ"))*delta;

        //System.out.println("vitesse z: "+vitesseActuZ);
        resetCommand();   
    }
    @Override
    public void attaque(){

    }

    public void getGameCommand(){
        Map<String,Boolean> commandeJeu = Jeu.getDirectionJeu();
        if (commandeJeu.get("Right") && commandeJeu.get("Left")){}
        else if (commandeJeu.get("Right")) tableCommande.replace("CommandX", vitesseMax);
        else if (commandeJeu.get("Left")) tableCommande.replace("CommandX", -vitesseMax);
        if (commandeJeu.get("Jump")) {
            if (this.getCoord().getZ() < Jeu.getCoordSol().getZ())alpha = 0;
            else if (this.getVitesseActuZ() == 0){tableCommande.replace("CommandZ", impulsionSaut);/*A.add(charac.getCoord().getZ());n++;*/}
            }
            else {
                tableCommande.replace("CommandZ", (double)0);
            if (this.getCoord().getZ() < Jeu.getCoordSol().getZ()) { //a retoucher, j'ai besoin d'autres choses pour avancer
                alpha = 0; 
            }
            else{
                alpha = 1;
            }
        
        }
            
            
    }

    void resetCommand(){
        for (String key : tableCommande.keySet()){
            tableCommande.replace(key, (double)0);
        }
    }

    public void evolveCharacter(){
        deplacements();
    }

    public double getVitesseMax() {
        return vitesseMax;
    }

    public double getVitesseActuX() {
        return vitesseActuX;
    }

    public double getVitesseActuZ() {
        return vitesseActuZ;
    }

    public double getM() {
        return masse;
    }
    public double getImpulsionSaut() {
        return impulsionSaut;
    }
    @Override
    public double getEntityWIDTH() {
        return this.characterWIDTH;
    }
    @Override
    public double getEntityHEIGHT() {
        return this.characterHEIGHT;
    }
    
}
