package map;


import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;

import entity.Bat;
import entity.Boss;
import entity.Monster;
import environnement.Coordonnees;
import environnement.HitBox;
import jeu.Jeu;
import loaders.LoadSave;


public class LevelManager {


	private BufferedImage[] levelSprite;
	private Level levelOne;
	private List<BufferedImage> obstacleImage = new ArrayList<>();

	public LevelManager() {
		importOutsideSprites();
		levelOne = new Level(LoadSave.GetLevelData());
	}

	private BufferedImage[] importOutsideSprites() {
		BufferedImage img = LoadSave.GetSpriteAtlas(LoadSave.LEVEL_SPRITES);
		levelSprite = new BufferedImage[11];

		//Pour les sprites de chaque bloc
		//longs blocs de 17 de hauteur
		levelSprite[0] = img.getSubimage(0, 0, 32, 544);
		//Blocs de 3 pixels de hauteur
		levelSprite[1] = img.getSubimage( 32,  0, 32, 96);
		//Blocs de 2 de hauteur
		levelSprite[2] = img.getSubimage(2 * 32, 0, 32, 64);
		//bloc de 2 de longueur
		levelSprite[3] = img.getSubimage(3 * 32, 0, 64, 32);
		//Bloc de 3 de longeur
		levelSprite[4] = img.getSubimage(5 * 32, 0, 96, 32);
		//Coffres
		levelSprite[5] = img.getSubimage(3 * 32, 32, 32, 32);
		//Long bloc de 7 de longueur
		levelSprite[6] = img.getSubimage(32, 4 * 32, 224, 32);
		//Porte du boss
		levelSprite[7] = img.getSubimage(4 * 32, 32, 32, 96);
		//Terre verticale de 6 de hauteur
		levelSprite[8] = img.getSubimage(8 * 32, 0, 32, 192);
		//Terre horizontale de 7 de longueur
		levelSprite[9] = img.getSubimage(32, 5 * 32, 224, 32);
		//longs blocs de 20 de hauteur
		levelSprite[10] = img.getSubimage(9 * 32, 0, 32, 640);
		/*for (int j = 0; j < 2; j++)
			for (int i = 0; i < 9; i++) {
				int index = j * 9 + i;
				levelSprite[index] = img.getSubimage(i * 32, j * 32, 32, 32);
			}*/
		return levelSprite;
	}



	public List<Obstacle> generateObstacleTable() {
		List<Obstacle> obstacleList = new ArrayList<>();
		BufferedImage[] tabImages = importOutsideSprites();
		for (int j = 0; j < Jeu.TILES_IN_HEIGHT; j++){
			for (int i = 0; i < Jeu.TILES_IN_WIDTH; i++) {
				int index = levelOne.getSpriteIndex(i, j);

				//Index selon la couleur associée au bloc
				//longs blocs de 17 de hauteur
				if (index==0) {
					obstacleList.add(new Obstacle(new HitBox(new Coordonnees(Jeu.TILES_SIZE * i+Jeu.TILES_SIZE/2, Jeu.TILES_SIZE * j-17*Jeu.TILES_SIZE/2), 17*Jeu.TILES_SIZE, 1*Jeu.TILES_SIZE)));
					obstacleImage.add(tabImages[0]);
				}
				//Blocs de 3 pixels de hauteur
				if (index==1) {
					obstacleList.add(new Obstacle(new HitBox(new Coordonnees(Jeu.TILES_SIZE * i+Jeu.TILES_SIZE/2, Jeu.TILES_SIZE * j-3*Jeu.TILES_SIZE/2), 3*Jeu.TILES_SIZE, 1*Jeu.TILES_SIZE)));
					obstacleImage.add(tabImages[1]);
				}
				//Blocs de 2 de hauteur
				if (index==2) {
					obstacleList.add(new Obstacle(new HitBox(new Coordonnees(Jeu.TILES_SIZE * i+Jeu.TILES_SIZE/2, Jeu.TILES_SIZE * j-2*Jeu.TILES_SIZE/2), 2*Jeu.TILES_SIZE, 1*Jeu.TILES_SIZE)));
					obstacleImage.add(tabImages[2]);
				}
				//bloc de 2 de longueur
				if (index==3) {
					obstacleList.add(new Obstacle(new HitBox(new Coordonnees(Jeu.TILES_SIZE * i+2*Jeu.TILES_SIZE/2, Jeu.TILES_SIZE * j-Jeu.TILES_SIZE/2), 1*Jeu.TILES_SIZE, 2*Jeu.TILES_SIZE)));
					obstacleImage.add(tabImages[3]);
				}
				//Bloc de 3 de longeur
				if (index==5) {
					obstacleList.add(new Obstacle(new HitBox(new Coordonnees(Jeu.TILES_SIZE * i+3*Jeu.TILES_SIZE/2, Jeu.TILES_SIZE * j-Jeu.TILES_SIZE/2), 1*Jeu.TILES_SIZE, 3*Jeu.TILES_SIZE)));
					obstacleImage.add(tabImages[4]);
				}
				//Porte du boss
				if (index==14) {
					obstacleList.add(new Obstacle(new HitBox(new Coordonnees(Jeu.TILES_SIZE * i+1*Jeu.TILES_SIZE/2, Jeu.TILES_SIZE * j-3*Jeu.TILES_SIZE/2), 3*Jeu.TILES_SIZE, 1*Jeu.TILES_SIZE)));
					obstacleImage.add(tabImages[7]);
				}
				//Terre verticale de 6 de hauteur
				if (index==8) {
					obstacleList.add(new Obstacle(new HitBox(new Coordonnees(Jeu.TILES_SIZE * i+1*Jeu.TILES_SIZE/2, Jeu.TILES_SIZE * j-6*Jeu.TILES_SIZE/2), 6*Jeu.TILES_SIZE, 1*Jeu.TILES_SIZE)));
					obstacleImage.add(tabImages[8]);
				}
				//Terre horizontale de 7 de longueur
				if (index==51) {
					obstacleList.add(new Obstacle(new HitBox(new Coordonnees(Jeu.TILES_SIZE * i+7*Jeu.TILES_SIZE/2, Jeu.TILES_SIZE * j-1*Jeu.TILES_SIZE/2), 1*Jeu.TILES_SIZE, 7*Jeu.TILES_SIZE)));
					obstacleImage.add(tabImages[9]);
				}
				//Long bloc de 7 de longueur
				if (index==41) {
					obstacleList.add(new Obstacle(new HitBox(new Coordonnees(Jeu.TILES_SIZE * i+7*Jeu.TILES_SIZE/2, Jeu.TILES_SIZE * j-Jeu.TILES_SIZE/2), 1*Jeu.TILES_SIZE, 7*Jeu.TILES_SIZE)));
					obstacleImage.add(tabImages[6]);
				}
				//longs blocs de 20 de hauteur
				if (index==9) {
					obstacleList.add(new Obstacle(new HitBox(new Coordonnees(Jeu.TILES_SIZE * i+Jeu.TILES_SIZE/2, Jeu.TILES_SIZE * j-20*Jeu.TILES_SIZE/2), 20*Jeu.TILES_SIZE, 1*Jeu.TILES_SIZE)));
					obstacleImage.add(tabImages[10]);
				}

			}
		}return obstacleList;
	}
	public List<Monster> generateMonsterTable() {
		List<Monster> monsterList = new ArrayList<>();
		for (int j = 0; j < Jeu.TILES_IN_HEIGHT; j++){
			for (int i = 0; i < Jeu.TILES_IN_WIDTH; i++) {
				int index = levelOne.getSpriteIndex(i, j);

				//Monstres à pied
				if (index == 15) {
					monsterList.add(new Monster(new Coordonnees(32 * i + 30 / 2, 32 * j - 62 / 2), 1000, 30, 60, 1, 5));

				}
				//chauve-souris
				if (index == 16) {
					monsterList.add(new Bat(new Coordonnees(32 * i + 20 / 2, 32 * j - 30 / 2), 1, 3));

				}
				//Boss
				if (index == 17) {
					monsterList.add(new Boss(new Coordonnees(32*i, 32*j-96/2), 500, 32, 96, 3, 50));

				}
			}
		}return monsterList;
	}

	public List<Coffre> generateCoffreTable(){
		List<Coffre> coffreListe = new ArrayList<>();
		
		for (int j = 0; j < Jeu.TILES_IN_HEIGHT; j++){
			for (int i = 0; i < Jeu.TILES_IN_WIDTH; i++) {
				int index = levelOne.getSpriteIndex(i, j);
				//Coffres
				if (index==13) {
					coffreListe.add(new Coffre(new HitBox(new Coordonnees(Jeu.TILES_SIZE * i+Jeu.TILES_SIZE/2, Jeu.TILES_SIZE * j-Jeu.TILES_SIZE/2), Jeu.TILES_SIZE, Jeu.TILES_SIZE)));
				}

			}
		}
		return coffreListe;
	}


	public void update() {

	}

	public Level getCurrentLevel() {
		return levelOne;
	}

	public List<BufferedImage> getObstacleImage() {
		return obstacleImage;
	} 

	public BufferedImage getImageCoffre() {
		return importOutsideSprites()[5];
	} 
	
}
