package entity;

import java.util.List;

import environnement.Coordonnees;
import jeu.Jeu;

public class ShootingCharacter extends Character{

    private int hasAttacked = 0; //varialbe disant si il a deja attaque, il ne peut attaque que toutes les deux frames, ainsi il ne peut attaquer que si = 0
    private int stockMaxKunai = 10;
    private int stockKunai = stockMaxKunai;
    private int kunaiReloading = 0; //temps de rechargement des kunais
    public ShootingCharacter(Coordonnees c, double vitesseMax, double m, double impSaut){
        super(c, vitesseMax, m, impSaut);
    }

    public void attaque(){
        if (this.getTableCommande().get("CommandAttack") != 0 && hasAttacked == 0 && stockKunai > 0){ //on ajoute un kunai dans la liste
            List<Kunai> temp = Jeu.getKunaiList();
            Coordonnees coordKunai = new Coordonnees(coord.getX() + (direction * (double) Kunai.getWidth() / 2) + ((direction * this.getEntityWIDTH()) / 2), coord.getZ());
            temp.add(new Kunai(direction, attackStat, coordKunai));
            Jeu.setKunaiList(temp);
            stockKunai--;
            hasAttacked++;
        }
    }

    public void evolveCharacter(){
        super.evolveCharacter();
        if (hasAttacked > 0){
            hasAttacked++;
            if (hasAttacked > 50)hasAttacked = 0; 
        }
        if (kunaiReloading == 299){//si on a passe les temps de rechargement d un kunai
            stockKunai = Math.min(stockKunai+1, stockMaxKunai);
        }
        kunaiReloading = (kunaiReloading+1)%300;
        if (stockKunai == stockMaxKunai) { //pour apprecier la duree de rechargement totale
            //System.out.println("yo");
        }
    }
}
