package environnement;

import java.util.HashMap;

public class HitBox {

    //private final Coordonnees centre;
    private HashMap<String, Coordonnees> extremites = new HashMap<>();
    private static double defaultUnit = 10;
    private double width;
    private double height;
    private Coordonnees centre;

    public double getWidth() {
        return width;
    }

    public double getHeight() {
        return height;
    }

    public Coordonnees getCentre() {
        return centre;
    }

    public HitBox(Coordonnees c){
        extremites.put("HautDroite",new Coordonnees(c.getX()+defaultUnit/2,c.getZ()-defaultUnit/2));
        extremites.put("BasDroite",new Coordonnees(c.getX()+defaultUnit/2,c.getZ()+defaultUnit/2));
        extremites.put("HautGauche",new Coordonnees(c.getX()-defaultUnit/2,c.getZ()-defaultUnit/2));
        extremites.put("BasGauche",new Coordonnees(c.getX()-defaultUnit/2,c.getZ()+defaultUnit/2));
        centre = c;
    }

    public HitBox(Coordonnees c , double Height , double Width){
        extremites.put("HautDroite",new Coordonnees(c.getX()+Width/2,c.getZ()-Height/2));
        extremites.put("BasDroite",new Coordonnees(c.getX()+Width/2,c.getZ()+Height/2));
        extremites.put("HautGauche",new Coordonnees(c.getX()-Width/2,c.getZ()-Height/2));
        extremites.put("BasGauche",new Coordonnees(c.getX()-Width/2,c.getZ()+Height/2));
        width = Width;
        height = Height;
        centre = c;
    }

    public static int getDefaultUnit() {
        return (int)defaultUnit;
    }

    public static Boolean collision(HitBox A, HitBox B){ // lignes sautées pour raison de lisibilité

        return (!(A.extremites.get("HautGauche").getX() >= B.extremites.get("HautDroite").getX())) // A est à droite de B
                && (!(A.extremites.get("HautDroite").getX() <= B.extremites.get("HautGauche").getX())) // A est à gauche de B
                && (!(A.extremites.get("HautGauche").getZ() >= B.extremites.get("BasGauche").getZ())) // A est en dessous de B
                && (!(A.extremites.get("BasGauche").getZ() <= B.extremites.get("HautGauche").getZ())); // A est au dessus de B
    }
    public HashMap<String, Coordonnees> getExtremites() {
        return extremites;
    }

    public static Boolean collisionDroite(HitBox A, HitBox B){
        return !(A.extremites.get("HautGauche").getX() > B.extremites.get("HautDroite").getX());// A est à droite de B
    }
    public static Boolean collisionGauche(HitBox A, HitBox B){
        return !(A.extremites.get("HautDroite").getX() < B.extremites.get("HautGauche").getX());// A est à gauche de B
    }
    public static Boolean collisionBas(HitBox A, HitBox B){
        System.out.println(A.extremites.get("HautGauche").getZ()+"     "+B.extremites.get("BasGauche").getZ());
        return !(A.extremites.get("HautGauche").getZ() > B.extremites.get("BasGauche").getZ());// A est en dessous de B
    }
    public static Boolean collisionHaut(HitBox A, HitBox B){
        return !(A.extremites.get("BasGauche").getZ() < B.extremites.get("HautGauche").getZ());// A est au dessus de B
    }
}