package entity;

import environnement.Coordonnees;
import environnement.HitBox;
import jeu.Jeu;
import map.Obstacle;

public abstract class Entity {
    private Coordonnees coord; 
    protected Coordonnees oldCoord;
    final double vitesseMax;
    protected HitBox hitBox;

    private final double entityWIDTH = 10;
    private final double entityHEIGHT = 10;

    protected Obstacle obstacleBeneath = Jeu.getSol();

    public Entity(Coordonnees c,double vitesseMax){
        this.coord = c;
        this.vitesseMax = vitesseMax;
        this.hitBox = new HitBox(c, entityHEIGHT, entityWIDTH);
    }
    public void deplacements(){}
    public void attaque(){}
    public Coordonnees getCoord(){
        return this.coord;
    } // Pour retourner les coordonées
    public void setCoord(Coordonnees coord) {
        this.coord = coord;
    }
    public double getEntityWIDTH() {
        return entityWIDTH;
    }
    public double getEntityHEIGHT() {
        return entityHEIGHT;
    }
    public Coordonnees getOldCoord() {
        return oldCoord;
    }
    public HitBox getHitBox() {
        return hitBox;
    }
    public Obstacle getObstacleBeneath() {
        return obstacleBeneath;
    }
    public void setHitBox(HitBox hitBox) {
        this.hitBox = hitBox;
    }
    public void setObstacleBeneath(Obstacle obstacleBeneath) {
        this.obstacleBeneath = obstacleBeneath;
    }

    
}
