package entity;

import java.util.HashMap;
import java.util.Map;

import environnement.Coordonnees;
import environnement.HitBox;
import map.Obstacle;
import environnement.Physique;
import jeu.Jeu;

public class Character extends Entity{

    private double vitesseActuX = 0; // vitesse actuelle supposée nulle au départ
    private double vitesseActuZ = 0;
    private final double impulsionSaut;
    private double masse;
    private int alpha = 1; // gere les collisions avec le sol
    
    private final double entityWIDTH = 30; // pour l'instant je les ai renommes, ca peut changer
    private final double entityHEIGHT = 60;
    private Map<String,Double> tableCommande; //table des commandes du perso
    //private BufferedImage sprite;
    


    public Character(Coordonnees c, double vitesseMax, double m, double impSaut){
        super(c,vitesseMax); // comme tous les entities ont une hitbox, j'ai factorise
        this.masse = m;
        this.oldCoord = this.getCoord();
        this.impulsionSaut = impSaut;
        this.setHitBox(new HitBox(c,entityHEIGHT,entityWIDTH));
        this.tableCommande = new HashMap<>();
        tableCommande.put("CommandX",(double)0);
        tableCommande.put("CommandZ",(double)0);
        //sprite = CharacterLoader.getImageCharacter();
        
    }
    @Override
    public void deplacements(){ // alpha indique si il est au sol ou non, il vaut 0 ou 1 en fonction
        
        double delta = Math.pow(10, -3); // pas de temps remis en secondes

        //on actualise les positions
        double newX,newZ;
        //on se souvient de ses anciennes positions
        this.oldCoord = this.getCoord();

        newX =  tableCommande.get("CommandX")*delta + this.getCoord().getX();

        
        newZ = ((1-alpha)*Physique.g - tableCommande.get("CommandZ"))/2*delta*delta + vitesseActuZ*delta + this.getCoord().getZ();
        if (newZ+entityHEIGHT/2 >= obstacleBeneath.getHitbox().getExtremites().get("HautGauche").getZ()){
            newZ = obstacleBeneath.getHitbox().getExtremites().get("HautGauche").getZ()-entityHEIGHT/2;
            //alpha = 1;
        }

        //(tableCommande.get("CommandZ") == 0) this.getCoord().getZ()(tableCommande.get("CommandZ") == 0) && 

        this.setCoord(new Coordonnees(newX, newZ)); // on set les nouvelles coordonnees
        System.out.println("z = "+this.getCoord().getZ());
 
        //on actualise les vitesses
        vitesseActuX = tableCommande.get("CommandX");

        if (alpha == 1) vitesseActuZ = 0;
        /*else*/ vitesseActuZ = vitesseActuZ + 7*((1-alpha)*Physique.g - tableCommande.get("CommandZ"))*delta;
        System.out.println("vitesse z = "+vitesseActuZ);


           
    }
    @Override
    public void attaque(){

    }

    public void getGameCommand(){
        Map<String,Boolean> commandeJeu = Jeu.getDirectionJeu();
        if (commandeJeu.get("Right") && commandeJeu.get("Left")){tableCommande.replace("CommandX", (double)0);}
        else if (commandeJeu.get("Right")) tableCommande.replace("CommandX", vitesseMax);
        else if (commandeJeu.get("Left")) tableCommande.replace("CommandX", -vitesseMax);

        
        if (commandeJeu.get("Jump")) {
            if ((alpha == 1) && (this.getVitesseActuZ() == 0)){
                tableCommande.replace("CommandZ", impulsionSaut);
            }      
        }
    }

    public void checkIfOnGround(){ // faut modifier la condition pour la gestion de colisions avec le sol
        obstacleBeneathCharacter(); // cherche l'obstacle en-dessous du personnage
        if (!Obstacle.collisionBas(this)){
            alpha = 0;
        }
        else alpha = 1;
    }

    public void obstacleBeneathCharacter(){
        Obstacle obsMin = Jeu.getSol();
        for (Obstacle obs : Jeu.getObstacleTable()){
            if (obs != Jeu.getSol() && obs.getHitbox().getExtremites().get("HautDroite").getZ() >= this.getCoord().getZ() && HitBox.collisionDroite(hitBox, obs.getHitbox()) && HitBox.collisionGauche(hitBox, obs.getHitbox())){
                if (obs.getHitbox().getExtremites().get("HautDroite").getZ() < obsMin.getHitbox().getExtremites().get("HautDroite").getZ()){
                    obsMin = obs;
                }
            }
        }obstacleBeneath = obsMin;
    }

    public void checkIfNextToWall(){
        if ((Obstacle.collisionDroite(this, Jeu.getObstacleTable()) && tableCommande.get("CommandX") == -vitesseMax) || (Obstacle.collisionGauche(this, Jeu.getObstacleTable()) && tableCommande.get("CommandX") == vitesseMax)){
            this.setCoord(new Coordonnees(this.oldCoord.getX(), this.getCoord().getZ()));
        }
    }

    public void resetCommand(){
        for (String key : tableCommande.keySet()){
            tableCommande.replace(key, (double)0);
        }
    }

    public void evolveCharacter(){
        System.out.println(alpha);
        getGameCommand();
        checkIfOnGround();
        //checkIfNextToWall();
        deplacements();
        checkIfNextToWall();
        resetCommand();
        this.setHitBox(new HitBox(this.getCoord(),entityHEIGHT,entityWIDTH)); // mise à jour moins crade pour l'instant
    }

    public double getVitesseMax() {
        return vitesseMax;
    }

    public double getVitesseActuX() {
        return vitesseActuX;
    }

    public double getVitesseActuZ() {
        return vitesseActuZ;
    }

    public double getM() {
        return masse;
    }
    public double getImpulsionSaut() {
        return impulsionSaut;
    }
    @Override
    public double getEntityWIDTH() {
        return this.entityWIDTH;
    }
    @Override
    public double getEntityHEIGHT() {
        return this.entityHEIGHT;
    }
    public int getAlpha() {
        return alpha;
    }
    
}
