package jeu;

import engine.GamePainter;
import entity.Monster;
import environnement.Coordonnees;
import environnement.HitBox;
import loaders.ObstacleLoader;
import map.Obstacle;
import loaders.CoffreLoader;
import map.Coffre;

import java.awt.*;
import java.awt.image.BufferedImage;
import java.util.HashMap;

import javax.swing.ImageIcon;

import java.net.URL;

import static environnement.HitBox.collision;
import static jeu.Jeu.*;


public class Painter implements GamePainter{

    protected static final int WIDTH = 1000;
    protected static final int HEIGHT = 1000;

    public static Obstacle test = new Obstacle(new HitBox(new Coordonnees(300,550),32,128));

    public Painter() {
        
    }

    @Override
    public void draw(BufferedImage im) {
        Graphics2D crayon = (Graphics2D) im.getGraphics();
        crayon.setColor(Color.blue);
        drawCharacter(crayon,gameCharacterLoader.getImageCharacter());

        //drawQuadrillage(crayon);*/
        drawMap(crayon);
        drawSol(crayon);
        drawObstacleBis(crayon,test,"plateforme.png");
        drawLifePoints(crayon);
        drawMonsters(crayon);
    }


    private void drawCharacter(Graphics2D crayon,Image imageCharac){
        int x = (int) gameCharacter.getCoord().getX();
        int y = (int) gameCharacter.getCoord().getZ();
        crayon.fillRect(x-(int) gameCharacter.getEntityWIDTH()/2,y-(int) gameCharacter.getEntityHEIGHT()/2, (int) gameCharacter.getEntityWIDTH(),(int) gameCharacter.getEntityHEIGHT());
        crayon.drawImage(imageCharac, x-(int) gameCharacter.getEntityWIDTH()/2-10, y- (int) gameCharacter.getEntityHEIGHT()/2-3, null, null);

    }

    private void drawLifePoints(Graphics2D crayon){
        String fn = "Frames_perso";
        URL url = Jeu.class.getClassLoader().getResource(fn);
        assert url != null;
        int placeX = -10;
        String beginPath = url.toString().substring(6)+"/";
        Image filledHeart = new ImageIcon(beginPath+"character_health2.png").getImage();
        Image emptyHeart = new ImageIcon(beginPath+"character_health1.png").getImage();
        for (int i=1;i<=gameCharacter.getNbLifePoints();i++){
            placeX += 45;
            crayon.drawImage(filledHeart, placeX, 10, null, null);
        }
        for (int i=1;i<=gameCharacter.getMaxLifePoints()-gameCharacter.getNbLifePoints();i++){
            placeX += 45;
            crayon.drawImage(emptyHeart, placeX, 10, null, null);
        }
    }

    private void drawObstacle(Graphics2D crayon, Obstacle obstacle){
        HashMap<String, Coordonnees> extremites = obstacle.getHitbox().getExtremites();
        Coordonnees hd = extremites.get("HautDroite");
        Coordonnees bd = extremites.get("BasDroite");
        Coordonnees hg = extremites.get("HautGauche");
        Coordonnees bg = extremites.get("BasGauche");
        crayon.drawLine((int)hd.getX(),(int)hd.getZ(),(int)bd.getX(),(int)bd.getZ());
        crayon.drawLine((int)bd.getX(),(int)bd.getZ(),(int)bg.getX(),(int)bg.getZ());
        crayon.drawLine((int)bg.getX(),(int)bg.getZ(),(int)hg.getX(),(int)hg.getZ());
        crayon.drawLine((int)hg.getX(),(int)hg.getZ(),(int)hd.getX(),(int)hd.getZ());

    }
    private void drawCoffre(Graphics2D crayon, Coffre coffre){
        HashMap<String, Coordonnees> extremites = coffre.getHitbox().getExtremites();
        Coordonnees hd = extremites.get("HautDroite");
        Coordonnees bd = extremites.get("BasDroite");
        Coordonnees hg = extremites.get("HautGauche");
        Coordonnees bg = extremites.get("BasGauche");
        crayon.drawLine((int)hd.getX(),(int)hd.getZ(),(int)bd.getX(),(int)bd.getZ());
        crayon.drawLine((int)bd.getX(),(int)bd.getZ(),(int)bg.getX(),(int)bg.getZ());
        crayon.drawLine((int)bg.getX(),(int)bg.getZ(),(int)hg.getX(),(int)hg.getZ());
        crayon.drawLine((int)hg.getX(),(int)hg.getZ(),(int)hd.getX(),(int)hd.getZ());

    }

    private void drawSol(Graphics2D crayon){
        ObstacleLoader loader = new ObstacleLoader(Jeu.getSol(),"Terre.png");
        HitBox hitBox = loader.getObstacle().getHitbox();
        int z = (int) hitBox.getCentre().getZ();
        for (int x = 0;x<3000;x+=128) {
            crayon.drawImage(loader.getImageObstacle(),x,z ,null,null);
        }
    }

    private void drawMap(Graphics2D crayon){
        for (Obstacle obs : Jeu.getObstacleTable()){
            if (!collision(gameCharacter.getHitBox(), obs.getHitbox())){
                crayon.setColor(Color.blue);
            }
            else {
                crayon.setColor(Color.red);
            }
            drawObstacle(crayon,obs);
        }
        for (Coffre obs : Jeu.getCoffreTable()){
            if (!collision(gameCharacter.getHitBox(), obs.getHitbox())){
                crayon.setColor(Color.blue);
            }
            else {
                crayon.setColor(Color.red);
            }
            drawCoffre(crayon,obs);
        }
    }

    private void drawObstacleBis(Graphics2D crayon, Obstacle obstacle, String nom){
        ObstacleLoader loader = new ObstacleLoader(obstacle,nom);
        HitBox hitBox = loader.getObstacle().getHitbox();
        int z = (int) hitBox.getCentre().getZ();
        int x = (int) hitBox.getCentre().getX();
        crayon.drawImage(loader.getImageObstacle(), x - (int) hitBox.getWidth()/2,z - (int) hitBox.getHeight()/2,null,null);
    }
    
    private void drawCoffreBis(Graphics2D crayon, Coffre coffre, String nom){
        CoffreLoader loader = new CoffreLoader(coffre,nom);
        HitBox hitBox = loader.getCoffre().getHitbox();
        int z = (int) hitBox.getCentre().getZ();
        int x = (int) hitBox.getCentre().getX();
        crayon.drawImage(loader.getImageCoffre(), x - (int) hitBox.getWidth()/2,z - (int) hitBox.getHeight()/2,null,null);
    }

    private void drawMonsters(Graphics2D crayon){
        int x;
        int z;
        crayon.setColor(Color.blue);
        for (Monster monster : getMonsterList()){
            crayon.setColor(Color.blue);
            x = (int)monster.getCoord().getX();
            z = (int)monster.getCoord().getZ();
            if (HitBox.collision(gameCharacter.getHitBox(),monster.getHitBox()))crayon.setColor(Color.red);
            crayon.fillRect(x-(int)monster.getEntityWIDTH()/2, z-(int)monster.getEntityHEIGHT()/2, (int)monster.getEntityWIDTH(), (int)monster.getEntityHEIGHT());
        }
    }

    @Override
    public int getWidth() {
        return WIDTH;
    }

    @Override
    public int getHeight() {
        return HEIGHT;
    }

}
