package entity;

import environnement.Coordonnees;
import environnement.HitBox;


public abstract class Entity {
    protected Coordonnees coord; 
    protected Coordonnees oldCoord;
    protected final double vitesseMax;
    protected HitBox hitBox;
    protected int attackStat; // nb de pv enleves par attaque
    protected int maxLifePoints = 3;
    protected int nbLifePoints = maxLifePoints;
    protected final double entityWIDTH;
    protected final double entityHEIGHT;
    protected int alpha = 1; // gere les collisions avec le sol
    protected HitBox voisinage;

    
    public Entity(Coordonnees c,double vitesseMax,double width,double height,int atkStt){
        this.coord = c;
        this.attackStat = atkStt;
        this.oldCoord = this.coord;
        this.vitesseMax = vitesseMax;
        this.entityHEIGHT = height;
        this.entityWIDTH = width;
        this.hitBox = new HitBox(c, entityHEIGHT, entityWIDTH);
        this.voisinage = new HitBox(c, 600, 600);
    }
    public void deplacements(){}

    public void attaque(){}
    
    public Coordonnees getCoord(){
        return this.coord;
    } // Pour retourner les coordonées

    public void setCoord(Coordonnees coord) {
        this.coord = coord;
    }
    
    public double getEntityWIDTH() {
        return entityWIDTH;
    }

    public double getEntityHEIGHT() {
        return entityHEIGHT;
    }

    public Coordonnees getOldCoord() {
        return oldCoord;
    }

    public HitBox getHitBox() {
        return hitBox;
    }

    public int getNbLifePoints() {
        return nbLifePoints;
    }

    public void setNbLifePoints(int nbLifePoints) {
        this.nbLifePoints = nbLifePoints;
    }

    public void setHitBox(HitBox hitBox) {
        this.hitBox = hitBox;
    }

    public double getVitesseMax() {
        return vitesseMax;
    }

    public int getMaxLifePoints() {
        return maxLifePoints;
    }

    public int getAlpha() {
        return alpha;
    }
    
    public int getAttackStat() {
        return attackStat;
    }

    public void updateVoisinage(){
        
    }
   
    public Boolean death(){return false;}
}
