package jeu;

import engine.Cmd;
import engine.Game;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;

public class Jeu implements Game{

    public Jeu(String source) {
        BufferedReader helpReader;
        try {
            helpReader = new BufferedReader(new FileReader(source));
            String line;
            while ((line = helpReader.readLine()) != null) {
                System.out.println(line);
            }
            helpReader.close();
        } catch (IOException e) {
            System.out.println("Help not available");
        }
    }

    @Override
    public void evolve(Cmd commande) {
        System.out.println("Execute "+commande);
        switch (commande) {
            case LEFT:
                break;
            case RIGHT:
                break;
            case JUMP:
                break;
            case IDLE:
                break;
        }
    }

    @Override
    public boolean isFinished() {
        // le jeu n'est jamais fini
        return false;
    }
    
}