package jeu;

import engine.Cmd;
import engine.GameController;

import java.awt.event.KeyEvent;

public class Controller implements GameController{
    /*
    * commande en cours
    */
    private Cmd commandeEnCours;

    /*
    * construction du controleur par defaut le controleur n'a pas de commande
    */

    public Controller() {
        this.commandeEnCours = Cmd.IDLE;
    }

    public Cmd getCommand() {
        return this.commandeEnCours;
    }
    @Override

    public void keyPressed(KeyEvent e) {

        switch (e.getKeyChar()) {
            // si on appuie sur 'q',commande joueur est gauche
            case 'q':
            case 'Q':
                this.commandeEnCours = Cmd.LEFT;
                break;
            case 'd':
            case 'D':
                this.commandeEnCours = Cmd.RIGHT;
                break;
            case ' ':
                this.commandeEnCours = Cmd.JUMP;
                break;
        }
    }
    @Override

    public void keyReleased(KeyEvent e) {
        this.commandeEnCours = Cmd.IDLE;
    }
    @Override

    public void keyTyped(KeyEvent e) {

    }

}