package jeu;

import engine.GamePainter;
import entity.Kunai;
import entity.Monster;
import environnement.Coordonnees;
import environnement.HitBox;
import loaders.ObstacleLoader;
import map.Obstacle;
import java.awt.*;
import java.awt.image.BufferedImage;
import java.util.HashMap;

import javax.swing.ImageIcon;

import java.net.URL;

import static environnement.HitBox.collision;
import static jeu.Jeu.*;
import map.LevelManager;


public class Painter implements GamePainter{

    //protected static final int WIDTH = TILES_SIZE*TILES_IN_WIDTH;
    //protected static final int HEIGHT = TILES_SIZE*TILES_IN_HEIGHT;
    protected static final int WIDTH =1500;
    protected static final int HEIGHT=1000;
    private LevelManager levelManager;
    public static Obstacle test = new Obstacle(new HitBox(new Coordonnees(300,550),32,128));

    private static Coordonnees coordonneesCam;
    public int xCam;
    public int zCam;
    private int decalage = 225;

    private Painter painter;
    public Painter() {

    }

    @Override
    public void draw(BufferedImage im) {
        coordonneesCam = gameCharacter.getCoord();
        xCam = -WIDTH/2 + (int) coordonneesCam.getX();
        zCam = -HEIGHT/2 +(int) coordonneesCam.getZ()-decalage;

        Graphics2D crayon = (Graphics2D) im.getGraphics();
        crayon.setColor(Color.blue);

        drawMap(crayon);
        drawSol(crayon);
        //drawObstacleBis(crayon,test,"plateforme.png"); // A changer
        drawLifePoints(crayon);
        drawKey(crayon);
        drawMonsters(crayon);
        drawKunais(crayon);

        drawCharacter(crayon,gameCharacterLoader.getImageCharacter());
    }


    private void drawCharacter(Graphics2D crayon,Image imageCharac){
        if (gameCharacter.getNbFramesInvincible() > 0)crayon.setColor(Color.black);
        crayon.fillRect(WIDTH/2-(int) gameCharacter.getEntityWIDTH()/2,HEIGHT/2-(int) gameCharacter.getEntityHEIGHT()/2+decalage, (int) gameCharacter.getEntityWIDTH(),(int) gameCharacter.getEntityHEIGHT());
        crayon.drawRect(WIDTH/2-500,WIDTH/2-500, 1000,1000);
        if (gameCharacter.getDirection() == 1){
            crayon.drawImage(imageCharac, WIDTH/2- (int) gameCharacter.getEntityWIDTH()/2-10, HEIGHT/2 - (int) gameCharacter.getEntityHEIGHT()/2-3+decalage, null, null);
        }
        else{
            crayon.drawImage(imageCharac, WIDTH/2- (int) gameCharacter.getEntityWIDTH()/2-10-30, HEIGHT/2 - (int) gameCharacter.getEntityHEIGHT()/2-3+decalage, null, null); 
        }
    }

    
    private void drawKey(Graphics2D crayon){
    	if(gameCharacter.key==0) {
    		crayon.fillRect(-10,20,-20,30);
    	}
    }
    private void drawLifePoints(Graphics2D crayon){
        String fn = "Frames_perso";
        URL url = Jeu.class.getClassLoader().getResource(fn);
        assert url != null;
        int placeX = -10;
        String beginPath = url.toString().substring(6)+"/";
        Image filledHeart = new ImageIcon(beginPath+"character_health2.png").getImage();
        Image emptyHeart = new ImageIcon(beginPath+"character_health1.png").getImage();
        for (int i=1;i<=gameCharacter.getNbLifePoints();i++){
            placeX += 45;
            crayon.drawImage(filledHeart, placeX, 10, null, null);
        }
        for (int i=1;i<=gameCharacter.getMaxLifePoints()-gameCharacter.getNbLifePoints();i++){
            placeX += 45;
            crayon.drawImage(emptyHeart, placeX, 10, null, null);
        }
    }

    private void drawObstacle(Graphics2D crayon, Obstacle obstacle){
        HashMap<String, Coordonnees> extremites = obstacle.getHitbox().getExtremites();
        Coordonnees hd = extremites.get("HautDroite");
        Coordonnees bd = extremites.get("BasDroite");
        Coordonnees hg = extremites.get("HautGauche");
        Coordonnees bg = extremites.get("BasGauche");
        if (HitBox.collision(gameCharacter.getVoisinage(), obstacle.getHitbox()))crayon.setColor(Color.green);
        crayon.drawLine((int)hd.getX() - xCam,(int)hd.getZ() - zCam,(int)bd.getX() - xCam,(int)bd.getZ() - zCam);
        crayon.drawLine((int)bd.getX() - xCam,(int)bd.getZ() - zCam,(int)bg.getX() - xCam,(int)bg.getZ() - zCam);
        crayon.drawLine((int)bg.getX() - xCam,(int)bg.getZ() - zCam,(int)hg.getX() - xCam,(int)hg.getZ() - zCam);
        crayon.drawLine((int)hg.getX() - xCam,(int)hg.getZ() - zCam,(int)hd.getX() - xCam,(int)hd.getZ() - zCam);

    }
    /*private void drawCoffre(Graphics2D crayon, Coffre coffre){
        HashMap<String, Coordonnees> extremites = coffre.getHitbox().getExtremites();
        Coordonnees hd = extremites.get("HautDroite");
        Coordonnees bd = extremites.get("BasDroite");
        Coordonnees hg = extremites.get("HautGauche");
        Coordonnees bg = extremites.get("BasGauche");
        crayon.drawLine((int)hd.getX(),(int)hd.getZ(),(int)bd.getX(),(int)bd.getZ());
        crayon.drawLine((int)bd.getX(),(int)bd.getZ(),(int)bg.getX(),(int)bg.getZ());
        crayon.drawLine((int)bg.getX(),(int)bg.getZ(),(int)hg.getX(),(int)hg.getZ());
        crayon.drawLine((int)hg.getX(),(int)hg.getZ(),(int)hd.getX(),(int)hd.getZ());

    }*/

    private void drawSol(Graphics2D crayon){
        ObstacleLoader loader = new ObstacleLoader(Jeu.getSol(),"Terre.png");
        HitBox hitBox = loader.getObstacle().getHitbox();
        int z = (int) hitBox.getCentre().getZ();
        for (int x = 0;x<3000;x+=128) {
            crayon.drawImage(loader.getImageObstacle(),x -xCam ,z - zCam,null,null);
        }
    }

    private void drawMap(Graphics2D crayon){
        //System.out.println("Nombre obstacle :"+Jeu.getObstacleTable().size());
        for (Obstacle obs : Jeu.getObstacleTable()){
            if (!collision(gameCharacter.getHitBox(), obs.getHitbox())){
                crayon.setColor(Color.blue);
            }
            else {
                crayon.setColor(Color.red);
            }
            drawObstacle(crayon,obs);
        }
        /*for (Coffre obs : Jeu.getCoffreTable()){
            if (!collision(gameCharacter.getHitBox(), obs.getHitbox())){
                crayon.setColor(Color.blue);
            }
            else {
                crayon.setColor(Color.red);
            }
            drawCoffre(crayon,obs);
        }*/
    }

    private void drawObstacleBis(Graphics2D crayon, Obstacle obstacle, String nom){
        ObstacleLoader loader = new ObstacleLoader(obstacle,nom);
        HitBox hitBox = loader.getObstacle().getHitbox();
        int z = (int) hitBox.getCentre().getZ();
        int x = (int) hitBox.getCentre().getX();
        crayon.drawImage(loader.getImageObstacle(), x - (int) hitBox.getWidth()/2 -xCam,z - (int) hitBox.getHeight()/2 -zCam,null,null);
    }
    
    /*private void drawCoffreBis(Graphics2D crayon, Coffre coffre, String nom){
        CoffreLoader loader = new CoffreLoader(coffre,nom);
        HitBox hitBox = loader.getCoffre().getHitbox();
        int z = (int) hitBox.getCentre().getZ();
        int x = (int) hitBox.getCentre().getX();
        crayon.drawImage(loader.getImageCoffre(), x - (int) hitBox.getWidth()/2,z - (int) hitBox.getHeight()/2,null,null);
    }*/

    private void drawMonsters(Graphics2D crayon){
        int x;
        int z;
        crayon.setColor(Color.blue);
        for (Monster monster : getMonsterList()){
            crayon.setColor(Color.blue);
            
            x = (int)monster.getCoord().getX();
            z = (int)monster.getCoord().getZ();
            crayon.drawRect(x-300 - xCam, z-300 - zCam, 600, 600);
            if (HitBox.collision(gameCharacter.getHitBox(),monster.getHitBox()))crayon.setColor(Color.red);
            if (monster.getNbFramesInvincible() > 0)crayon.setColor(Color.black);
            crayon.fillRect(x-(int)monster.getEntityWIDTH()/2 - xCam, z-(int)monster.getEntityHEIGHT()/2 - zCam, (int)monster.getEntityWIDTH(), (int)monster.getEntityHEIGHT());
        }
    }

    private void drawKunais(Graphics2D crayon){
        int x;
        int z;
        crayon.setColor(Color.blue);
        for (Kunai kunai : getKunaiList()){
            crayon.setColor(Color.blue);
            
            x = (int)kunai.getCoord().getX();
            z = (int)kunai.getCoord().getZ();
            if (HitBox.collision(gameCharacter.getHitBox(),kunai.getHitBox()))crayon.setColor(Color.red);
            crayon.fillRect(x-Kunai.getWidth()/2 - xCam, z-Kunai.getHeight()/2 - zCam, Kunai.getWidth(), Kunai.getHeight());
        }
    }

    @Override
    public int getWidth() {
        return WIDTH;
    }

    @Override
    public int getHeight() {
        return HEIGHT;
    }

}
