package map;

import entity.Entity;
import environnement.HitBox;
import environnement.PositionCollision;



public final class Obstacle {

    private final HitBox hitbox;

    public Obstacle(HitBox h){
        this.hitbox = h;
    }

    public static PositionCollision collision(Entity entity,Obstacle obs,int i){
        return HitBox.collisionObstacle(entity.getHitBox(), obs.getHitbox(), i, entity.getObstacleTableCollision());
    }
    public HitBox getHitbox() {
        return hitbox;
    }

    @Override
    public String toString() {
        return "Obstacle coordonnees" + hitbox.getCentre().getX() + " " + hitbox.getCentre().getZ();
    }

}
