package loaders;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;

import javax.imageio.ImageIO;

import jeu.Jeu;

public class LoadSave {


	//Association des differents sprites des blocs
	public static final String LEVEL_SPRITES = "Obstacles/Map_sprites.png";
	//Map composee de pixels
	public static final String LEVEL_ONE = "Obstacles/level_one_monster.png";

	public static BufferedImage GetSpriteAtlas(String fileName) {
		BufferedImage img = null;
		InputStream is = LoadSave.class.getResourceAsStream("/" + fileName);
		try {
			img = ImageIO.read(is);

		} catch (IOException e) {
			e.printStackTrace();
		} finally {
			try {
				is.close();
			} catch (IOException e) {
				e.printStackTrace();
			}
		}
		return img;
	}
	//Prend en compte la valeur de la composante rouge des pixels ce qui permet de differencier les blocs
	public static int[][] GetLevelData() {
		int[][] lvlData = new int[Jeu.TILES_IN_HEIGHT][Jeu.TILES_IN_WIDTH];
		BufferedImage img = GetSpriteAtlas(LEVEL_ONE);

		for (int j = 0; j < img.getHeight(); j++)
			for (int i = 0; i < img.getWidth(); i++) {
				Color color = new Color(img.getRGB(i, j));
				int value = color.getRed();
				//longs blocs de 6 de hauteur
				if (0<=value && value <= 10)
					value = 0;
				//Blocs de 3 pixels de hauteur
				if (11<=value && value <= 30)
					value = 1;
				//Blocs de 2 de hauteur
				if (31<=value && value <= 50)
					value = 2;
				//bloc de 2 de longueur
				if (51<=value && value <= 70)
					value = 3;
				//Bloc de 3 de longeur
				if (71<=value && value <= 90)
					value = 5;
				//Long bloc de 7 de longueur
				if (91<=value && value <= 110)
					value = 25;
				//Espaces vides
				if (111<=value && value <= 130)
					value = 12;
				//Coffres
				if (131<=value && value <= 150)
					value = 11;
				//MOnstres à pied
				if (151<=value && value <= 170)
					value = 13;
				//Bat
				if (171<=value && value <= 190)
					value = 14;
				//Liste des valeurs
				lvlData[j][i] = value;
			}
		return lvlData;

	}
}
