package entity;

import environnement.Coordonnees;
import environnement.HitBox;
import jeu.Jeu;

import static jeu.Jeu.getGameCharacter;
import static jeu.Jeu.getHearthList;

import java.util.List;

public class Hearth {
    private HitBox hitBox;
    private Coordonnees coord;
    private int width = 20;
    private int height = 20;

    public Hearth(Coordonnees coordinates){
        coord = coordinates;
        hitBox = new HitBox(coord, height, width);
    }

    private void heal(){
        if (HitBox.collision(hitBox, getGameCharacter().getHitBox())){
            getGameCharacter().setNbLifePoints(Math.min(getGameCharacter().getNbLifePoints()+1,getGameCharacter().getMaxLifePoints()));
            getHearthList().remove(this);
        }
    }

    public HitBox getHitBox() {
        return hitBox;
    }

    public int getWidth() {
        return width;
    }

    public int getHeight() {
        return height;
    }

    public static void evolveHearths(){ //on fait heal tous les coeurs
        int k = 0;
        List<Hearth> testList = getHearthList(); //necessaire pour l evolution de la bouble while
        while (k < getHearthList().size()) {
            //on sauvegarde la liste des coeurs avant de faire heal (ou non) le coeur a l indice k
            testList = getHearthList();
            //on le fait heal (ou non)
            getHearthList().get(k).heal();
            //si il a heal, il a alors disparu de la liste, donc les tailles ne sont plus les memes, on ne fait donc rien
            if (testList.size() == getHearthList().size());
                //sinon, les tailles sont les memes, on passe donc au coeur suivant
                k++;
        }
    }

    
}
