package entity;

import java.util.ArrayList;
import java.util.List;

import environnement.Coordonnees;
import environnement.HitBox;
import environnement.PositionCollision;
import static jeu.Jeu.getObstacleTable;
import static environnement.PositionCollision.NONE;
import map.Obstacle;


public abstract class Entity {

    Coordonnees coord; 
    Coordonnees oldCoord;
    final double vitesseMax;
    HitBox hitBox;
    int attackStat; // nb de pv enleves par attaque
    int maxLifePoints = 5;
    int nbLifePoints = maxLifePoints;
    final double entityWIDTH;
    final double entityHEIGHT;
    int alpha = 1; // gere les collisions avec le sol
    HitBox voisinage;
    int direction = 1; // direction selon l'axe des x, -1 pour la gauche et 1 pour la droite
    List<PositionCollision>  obstacleTableCollision = new ArrayList<>();
    int nbFramesInvincible = 0;
    int nbMaxFramesInvicible;

    
    public Entity(Coordonnees c,double vitesseMax,double width,double height,int atkStt){
        
        this.coord = c;
        this.attackStat = atkStt;
        this.oldCoord = this.coord;
        this.vitesseMax = vitesseMax;
        this.entityHEIGHT = height;
        this.entityWIDTH = width;
        this.hitBox = new HitBox(c, entityHEIGHT, entityWIDTH);
        this.voisinage = new HitBox(c, 600, 600);
        for (int i = 0;i<getObstacleTable().size();i++){
            obstacleTableCollision.add(NONE);
        }


        nbMaxFramesInvicible = 100;
    }
    private void deplacements(){}

    private void attaque(){}

    private void updateVoisinage(){}

    private void collisionGestion(){}

    private List<Obstacle> obstacleInVoisinage(){return new ArrayList<Obstacle>();}
   
    public Boolean death(){return false;}
    
    public Coordonnees getCoord(){
        return this.coord;
    } // Pour retourner les coordonées

    public void setCoord(Coordonnees coord) {
        this.coord = coord;
    }
    
    public double getEntityWIDTH() {
        return entityWIDTH;
    }

    public double getEntityHEIGHT() {
        return entityHEIGHT;
    }

    public Coordonnees getOldCoord() {
        return oldCoord;
    }

    public HitBox getHitBox() {
        return hitBox;
    }

    public int getNbLifePoints() {
        return nbLifePoints;
    }

    

    public void setNbLifePoints(int nbLifePoints) {
        this.nbLifePoints = nbLifePoints;
    }

    public void setHitBox(HitBox hitBox) {
        this.hitBox = hitBox;
    }

    public double getVitesseMax() {
        return vitesseMax;
    }

    public int getMaxLifePoints() {
        return maxLifePoints;
    }

    public int getAlpha() {
        return alpha;
    }
    
    public int getAttackStat() {
        return attackStat;
    }

    

    public List<PositionCollision> getObstacleTableCollision() {
        return obstacleTableCollision;
    }

    public int getDirection() {
        return direction;
    }
    public HitBox getVoisinage() {
        return voisinage;
    }
    public int getNbFramesInvincible() {
        return nbFramesInvincible;
    }   
    
}
