package loaders;
import map.Obstacle;

import javax.swing.*;
import java.awt.*;
import java.net.URL;

public class ObstacleLoader {

    private final Image imageObstacle;
    private final Obstacle obstacle;

    public Image getImageObstacle() {
        return imageObstacle;
    }

    public Obstacle getObstacle() {
        return obstacle;
    }

    public ObstacleLoader(Obstacle obs, String nom){
        String fn = "Obstacles/";
        URL url = ObstacleLoader.class.getClassLoader().getResource(fn);
        assert url != null;
        String path = url.toString().substring(6)+"/"+nom;
        obstacle = obs;
        imageObstacle = new ImageIcon(path).getImage();
    }
}
