package fr.nancy.iut;

import static org.junit.jupiter.api.Assertions.*;
import org.junit.jupiter.api.Test;
import javax.vecmath.Point3d;

/**
 * Created by dparsons on 12/08/15.
 */
public class SphereTest
{
    @Test
    public void testConstructeurSansParametre()
    {
        Sphere s1 = new Sphere();
        assertEquals(0.0, s1.getRadius(), 0.0);
    }

    @Test
    public void testContructeurParametre()
    {
        Sphere s1 = new Sphere(5.0);
        assertEquals(5.0, s1.getRadius(), 0.0);
    }


    @Test
    public void testContructeurParametres()
    {
        Sphere s1 = new Sphere(5.0, new Point3d(1.0, 2.0, 3.0));
        assertEquals(5.0, s1.getRadius(), 0.0);
        assertEquals(1.0, s1.getPos().x, 0.0);
    }


    @Test
    public void testComputeVolume() throws Exception
    {
      Sphere mySphere = new Sphere(1.5);
      assertEquals(14.137166941154069, mySphere.computeVolume(), 0.0);
    }


    @Test
    public void testDistanceTo() throws Exception
    {
      Sphere s1 = new Sphere(1.5, new Point3d(1.0, 2.0, 3.0));
      Sphere autre = new Sphere(1.5, new Point3d(2.0, 3.0, 4.0));
      assertEquals(1.7320508075688772, s1.distanceTo(autre), 0.0);
    }


    @Test
    public void testDistanceSquaredTo() throws Exception
    {
      Sphere s1 = new Sphere(1.5, new Point3d(1.0, 2.0, 3.0));
      Sphere autre = new Sphere(1.5, new Point3d(2.0, 3.0, 4.0));
      assertEquals(3.0, s1.distanceSquaredTo(autre), 0.0);
    }


    @Test
    public void testInContactWithTrue() throws Exception
    {
      Sphere s1 = new Sphere(1.5, new Point3d(1.0, 2.0, 3.0));
      Sphere autre = new Sphere(1.5, new Point3d(2.0, 3.0, 4.0));
      assertTrue(s1.inContactWith(autre));
    }

    @Test
    public void testInContactWithFalse() throws Exception
    {
      Sphere s1 = new Sphere(1.5, new Point3d(1.0, 2.0, 3.0));
      Sphere autre = new Sphere(1, new Point3d(10.0, 50.0, 40.0));
      assertFalse(s1.inContactWith(autre));
    }
}