# Affichage d'une sortie JSON

# Importations
import json
from pyDataverse.api import NativeApi, DataAccessApi
from pyDataverse.models import Dataverse

# Déclaration de l'entrepôt Dataverse
repository_choice = False
while repository_choice == False:
	if repository_choice == True : 
		break
	prompt_repository_choice = "Choix de l'entrepôt à requêter : "
	prompt_repository_choice += "\n\t1. Entrepôt CODR (https://tested-dataverse5.univ-lorraine.fr"
	prompt_repository_choice += "\n\t2. Entrepôt bac à sable (https://bac-dataverse.univ-lorraine.fr"
	prompt_repository_choice += "\n\t3. Entrepôt DOREL / production (https://dorel.univ-lorraine.fr"
	prompt_repository_choice += "Entrez votre choix [1-3] : "
	choice_repository = input (prompt_repository_choice)
	if choice_repository == "1" and repository_choice == False:
		base_url = "https://tested-dataverse5.univ-lorraine.fr"
		repository_choice = True
	elif choice_repository == "2" and repository_choice == False:
		base_url = "https://bac-dataverse.univ-lorraine.fr"
		repository_choice = True
	elif choice_repository == "3"  and repository_choice == False:
		base_url = "https://dorel.univ-lorraine.fr"
		repository_choice = True
	else:
		print ("\nJe n'ai pas compris votre choix...\n")

api_key = input ("Entrez ici votre clé API : ")
api = NativeApi(base_url,api_key)
data_api = DataAccessApi(base_url,api_key)


# Test de renvoi de version et de code http
print("Test de renvoi de version et de code http...")
resp = api.get_info_version()
print (resp.json())
print (resp.status_code)
print (resp)


# Affichage d'une arborescence en JSON
print("Test d'affichage d'une arborescence en JSON")
tree_root = input ("Entrez ici le nom de la collection dataverse racine (défaut : univ-lorraine) : ")
if tree_root != "":
	tree_root = tree_root
elif tree_root == "":
	tree_root = "univ-lorraine"
desired_items=[]
print("Choisissez les items à inclure. Choix possibles : o/o/o, o/o/n, o/n/n.")
desired_dataverse = input ("Dataverses (o/n, défaut oui) : ")
if desired_dataverse != "n":
	desired_items.append("dataverses")
desired_datasets = input ("Datasets (o/n, défaut oui) : ")
if desired_datasets != "n":
	desired_items.append("datasets")
desired_datafiles = input ("Fichiers (o/n, défaut non) : ")
if desired_datafiles == "o":
	desired_items.append("datafiles")

print (f"La collection dataverse racine est : {tree_root}")
print (f"Niveaux inclus : {desired_items}")

# génération de la sortie json
print("Génération de l'arborescence...")
tree = api.get_children(tree_root, children_types = desired_items)
formatted_tree = json.dumps(tree, sort_keys=False, indent=8)

# conversion de la sortie json en variable texte
print("Conversion en texte...")
tree_string = str(formatted_tree)

# enregistrement de la sortie json
tree_file_name_input = input("Choisissez un nom de fichier pour la sortie, sans l'extension : ")
tree_file_name = (f"{tree_file_name_input}.json")
print("Enregistrement...")
with open (tree_file_name, 'w') as tree_file_object:
	tree_file_object.write(tree_string)
print ("Fichier sauvegardé!")

