#télécharger un jeu de données 

# Importation de l'api native
from pyDataverse.api import NativeApi, DataAccessApi
from pyDataverse.models import Dataverse

# Déclaration de l'entrepôt Dataverse
repository_choice = False
while repository_choice == False:
	if repository_choice == True : 
		break
	prompt_repository_choice = "Choix de l'entrepôt à requêter : "
	prompt_repository_choice += "\n\t1. Entrepôt CODR (https://tested-dataverse5.univ-lorraine.fr"
	prompt_repository_choice += "\n\t2. Entrepôt bac à sable (https://bac-dataverse.univ-lorraine.fr"
	prompt_repository_choice += "\n\t3. Entrepôt DOREL / production (https://dorel.univ-lorraine.fr"
	prompt_repository_choice += "Entrez votre choix [1-3] : "
	choice_repository = input (prompt_repository_choice)
	if choice_repository == "1" and repository_choice == False:
		base_url = "https://tested-dataverse5.univ-lorraine.fr"
		repository_choice = True
	elif choice_repository == "2" and repository_choice == False:
		base_url = "https://bac-dataverse.univ-lorraine.fr"
		repository_choice = True
	elif choice_repository == "3"  and repository_choice == False:
		base_url = "https://dorel.univ-lorraine.fr"
		repository_choice = True
	else:
		print ("\nJe n'ai pas compris votre choix...\n")

api_key = input ("Entrez ici votre clé API : ")
api = NativeApi(base_url,api_key)
data_api = DataAccessApi(base_url,api_key)


# Test de renvoi de version et de code http
print("Test de renvoi de version et de code http...")
resp = api.get_info_version()
print (resp.json())
print (resp.status_code)
print (resp)

# Entrée du DOI
DOI_input = input ("Entrer ici le DOI complet : ")
DOI = f"doi:{DOI_input}"
dataset = api.get_dataset(DOI)

files_list = dataset.json()['data']['latestVersion']['files']

for file in files_list:
    filename = file["dataFile"]["filename"]
    file_id = file["dataFile"]["id"]
    print("File name {}, id {}".format(filename, file_id))

    response = data_api.get_datafile(file_id)
    with open(filename, "wb") as f:
        f.write(response.content)