# Affichage des métadonnées d'un jeu de données

import json
from pyDataverse.api import NativeApi, DataAccessApi
from pyDataverse.models import Dataverse

# Déclaration de l'entrepôt Dataverse (URL et clé API)
repository_choice = False
while repository_choice == False:
	if repository_choice == True : 
		break
	prompt_repository_choice = "Choix de l'entrepôt à requêter : "
	prompt_repository_choice += "\n\t1. Entrepôt CODR (https://tested-dataverse5.univ-lorraine.fr"
	prompt_repository_choice += "\n\t2. Entrepôt bac à sable (https://bac-dataverse.univ-lorraine.fr"
	prompt_repository_choice += "\n\t3. Entrepôt DOREL / production (https://dorel.univ-lorraine.fr"
	prompt_repository_choice += "Entrez votre choix [1-3] : "
	choice_repository = input (prompt_repository_choice)
	if choice_repository == "1" and repository_choice == False:
		base_url = "https://tested-dataverse5.univ-lorraine.fr"
		repository_choice = True
	elif choice_repository == "2" and repository_choice == False:
		base_url = "https://bac-dataverse.univ-lorraine.fr"
		repository_choice = True
	elif choice_repository == "3"  and repository_choice == False:
		base_url = "https://dorel.univ-lorraine.fr"
		repository_choice = True
	else:
		print ("\nJe n'ai pas compris votre choix...\n")

api_key = input ("Entrez ici votre clé API (facultatif pour l'export de métadonnées) : ")

# Intégration des paramètres
api = NativeApi(base_url,api_key)
data_api = DataAccessApi(base_url,api_key)


# Test de renvoi de version et de code http
print("Test de renvoi de version et de code http...")
resp = api.get_info_version()
print (resp.json())
print (resp.status_code)
print (resp)
print("\n")

# Entrée du DOI
DOI_input = input ("Entrer ici le DOI complet : ")
DOI = f"doi:{DOI_input}"

# Requête et de la représentation JSON du dataset
print("Requête API en cours...")
dataset = api.get_dataset(identifier = DOI).json()["data"]["latestVersion"]["metadataBlocks"]["citation"]
# dataset = api.get_dataset(identifier = DOI).json()["data"]["latestVersion"]["metadataBlocks"]["citation"]
print(dataset)

# Mise en forme du fichier JSON
print("Mise en forme du JSON...")
formatted_dataset = json.dumps(dataset, sort_keys=False, indent=8)

# Affichage du dataset
print (formatted_dataset)

# conversion de la sortie json en variable texte
print("Conversion en texte...")
dataset_string = str(formatted_dataset)

# Enregistrement de la sortie JSON
dataset_file_name_input = input("Choisissez un nom de fichier pour la sortie, sans l'extension (qui sera .json) : ")
dataset_file_name = (f"{dataset_file_name_input}.json")
print("Enregistrement...")
with open (dataset_file_name, 'w') as dataset_file_object:
	dataset_file_object.write(dataset_string)
print ("Fichier sauvegardé!")
