# ===================================================================================
# Export des métadonnées de l'ensemble des jeux de données d'une collection Dataverse
#                    (incluant les sous-collections jusqu'à 4 niveaux)
# ===================================================================================


print ("\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n")
print ("# ===========================================================================#")
print ("#             Export des métadonnées de l'ensemble des jeux de               #")
print ("#                   données d'une collection Dataverse                       #")
print ("#             (incluant les sous-collections jusqu'à 4 niveaux)              #")
print ("# ===========================================================================#")


# !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
# !!!!!!!!! TODO !!!!!!!!!!!!!!!!!
# - Version parallèle à réaliser acceptant les paramètres d'entrepôt et de collection comme arguments d'une commande en ligne.

# -----------------------
# Imports et déclarations
# -----------------------

import json
import os
from pyDataverse.api import NativeApi, DataAccessApi
from pyDataverse.models import Dataverse

# ----------------------------------------------------
# Déclaration de l'entrepôt Dataverse (URL et clé API)
# ----------------------------------------------------

repositories = {
	"1. Entrepôt CODR" : "https://tested-dataverse5.univ-lorraine.fr" ,
	"2. Entrepôt bac à sable" : "https://bac-dataverse.univ-lorraine.fr" ,
 	"3. DOREL / production" : "https://dorel.univ-lorraine.fr",
 	"4. Démo Dataverse" : "https://demo.dataverse.org"
}

print ("Depuis quel entrepôt voulez-vous effectuer cet export ? ")
for repository_name, repository_URL in repositories.items():
	print (f"\t{repository_name} : {repository_URL})")
choice_repository = 0
while choice_repository not in ("1", "2", "3", "4"):
	choice_repository = input ("Effectuez votre choix : ")
	for repository_name, repository_URL in repositories.items():
		if choice_repository == repository_name [0]:
			base_url = repository_URL
			break
print (f"Adresse de l'entrepôt : {base_url}")

api_key = input ("Entrez ici votre clé API (facultatif pour l'export de métadonnées) : ")

api = NativeApi(base_url,api_key)
data_api = DataAccessApi(base_url,api_key)

# Test de renvoi de version et de code http
print("Test de renvoi de version et de code http...")
resp = api.get_info_version()
print (resp.json())
print (resp.status_code)
print (resp)

# Entrée de la collection à exporter
dataverse_root = input ("Entrez ici le nom de la collection dataverse à exporter (défaut : univ-lorraine) : ")
if dataverse_root != "":
	dataverse_root = dataverse_root
elif dataverse_root == "":
	dataverse_root = "univ-lorraine"

# ---------------------------------------------------------------
# Création d'une liste des identifiants de collections dataverses
# ---------------------------------------------------------------

# détermination de la liste des collections et sous-collections
# la hiérarchie des listes de collections est : dataverse_list > dataverse_children_level_2 > dataverse_children_level_3 > ...
# la hiérarchie des noms de collections est  : dataverse entry > dataverse_child_level_2 > dataverse_child_level_3 > ...
# TODO : revoir ça plus élégamment avec des fonctions...

print ("\nÉnumération des sous-collections...")
dataverse_list = api.get_children(dataverse_root, children_types = ["dataverses"])
dataverse_list = json.dumps(dataverse_list) # dump de la sortie json générée précédemment
dataverse_list = json.loads(dataverse_list) # Conversion en dictionnaire de la liste des datasets
dataverse_id_list = []
dataverse_alias_list = []
dataverse_alias_list.append(f"{dataverse_root}") # on n'oublie pas de tenir compte de la collection racine dans la liste!
for dataverse_entry in dataverse_list : # on prend chaque entrée (dictionnaire) de la liste
	dataverse_alias = dataverse_entry["dataverse_alias"] # on récupère l'alias du dataverse (ex. "lmops")
	dataverse_id = dataverse_entry["dataverse_id"] # on récupère l'identifiant du dataverse (ex. "9231")
	print (f"{dataverse_alias} : {dataverse_id}")
	dataverse_alias_list.append(dataverse_alias) # on ajoute l'alias à la liste
	dataverse_id_list.append(dataverse_id) # on ajoute l'id à la liste
	dataverse_children_level_2 = dataverse_entry["children"] # Le contenu des "children" des est stocké dans une liste
	if dataverse_children_level_2 != "":
# Traitement des sous-dataverses de niveau 2 (children_level_2)
		for dataverse_child_level_2 in dataverse_children_level_2:
			dataverse_alias = dataverse_child_level_2["dataverse_alias"] # on récupère l'alias du dataverse enfant (ex. "sous-plateforme_spectro")
			dataverse_id = dataverse_child_level_2["dataverse_id"] # on récupère l'identifiant du dataverse (ex. "12345")
			print (f"{dataverse_alias} : {dataverse_id} (est un enfant de : {dataverse_entry['dataverse_alias']}\n")
			dataverse_alias_list.append(dataverse_alias) # on ajoute l'alias à la liste
			dataverse_id_list.append(dataverse_id) # on ajoute l'id à la liste
			dataverse_children_level_3 = dataverse_child_level_2["children"] # Le contenu des "children" est stocké dans une liste
			if dataverse_children_level_3 != "":
		# Traitement des sous-dataverses de niveau 3 (children_level_3)
				for dataverse_child_level_3 in dataverse_children_level_3:
					dataverse_alias = dataverse_child_level_3["dataverse_alias"] # on récupère l'alias du dataverse enfant (ex. "sous-sous-plateforme_spectro")
					dataverse_id = dataverse_child_level_3["dataverse_id"] # on récupère l'identifiant du dataverse (ex. "12345")
					print (f"{dataverse_alias} : {dataverse_id} (est un enfant de : {dataverse_child_level_2['dataverse_alias']}\n")
					dataverse_alias_list.append(dataverse_alias) # on ajoute l'alias à la liste
					dataverse_id_list.append(dataverse_id) # on ajoute l'id à la liste
					dataverse_children_level_4 = dataverse_child_level_3["children"] # Le contenu des "children" des est stocké dans une liste
					if dataverse_children_level_4 != "" :
			# Traitement des sous-dataverses de niveau 4 (children_level_3)
						for dataverse_child_level_4 in dataverse_children_level_4:
							dataverse_alias = dataverse_child_level_4["dataverse_alias"] # on récupère l'alias du dataverse enfant (ex. "sous-sous-sous-plateforme_spectro")
							dataverse_id = dataverse_child_level_4["dataverse_id"] # on récupère l'identifiant du dataverse (ex. "12345")
							print (f"{dataverse_alias} : {dataverse_id} (est un enfant de : {dataverse_child_level_3['dataverse_alias']}\n")
							dataverse_alias_list.append(dataverse_alias) # on ajoute l'alias à la liste
							dataverse_id_list.append(dataverse_id) # on ajoute l'id à la liste
print (dataverse_alias_list)

# # formattage et sortie JSON de la liste des sous-collections dataverses sous la collection à exporter

# # formatted_dataverse_list = json.dumps(dataverse_list, sort_keys=False, indent=8)
# # formatted_dataverse_list_output_file = input ("Entrez un nom de fichier pour la sortie JSON de la liste des dataverses : \n")
# # with open (formatted_dataverse_list_output_file, 'w') as formatted_dataverse_list_output_file_object:
# # 	formatted_dataverse_list_output_file_object.write(formatted_dataverse_list)

# ----------------------------
# Création d'une liste des DOI
# ----------------------------
print ("\nRécupération des DOI...")
pid_list=[]
for dataverse_alias_for_export in dataverse_alias_list:
	dataset_list = api.get_children(dataverse_alias_for_export, children_types = ["datasets"])
	print (dataset_list)
	dataset_list = json.dumps(dataset_list) # dump de la sortie json générée précédemment
	dataset_list = json.loads(dataset_list) # Conversion en dictionnaire de la liste des datasets
	for dataset_entry in dataset_list: # on prend chaque entrée (dictionnaire) de la liste
		dataset_pid = dataset_entry["pid"] # on récupère le pid dans le dictionnaire dataset_entry
		print (dataset_pid)
		dataset_pid_truncated = dataset_pid[4:] # suppression des quatres premiers caractères (doi:) de la chaîne
		# print (dataset_pid)
		pid_list.append(dataset_pid_truncated) # on ajoute ce résultat à la liste pid_list
# print (pid_list)
print ("Liste des DOI :")
for pid in pid_list:
	print (pid)
print (f" {len(pid_list)} jeu(x) de données trouvé(s). ")
print (pid_list)

# --------------------------------------------------------------------------------------------
# Génération des sorties JSON de chaque dataset et écriture optionnelle d'un fichier de sortie
# --------------------------------------------------------------------------------------------


# file_wished_input = input("Souhaitez-vous exporter au format JSON o/n ? (défaut n) ") # Décommenter cette ligne pour rendre l'écriture optionnelle.
file_wished_input = "o" # Commenter cette ligne pour rendre l'écriture optionnelle.
if file_wished_input == "o":
	file_wished = True
	print("Un fichier va être créé.")
	complete_list_file_name_input = input("Choisissez un nom de fichier pour la sortie, sans l'extension. Défaut [export_json]: ")
	if complete_list_file_name_input == "":
		complete_list_file_name = "export_json.json"
	else : 
		complete_list_file_name = f"{complete_list_file_name_input}.json"
	with open (complete_list_file_name, 'a') as complete_list_file_object: 
		complete_list_file_object.write("{")			# ajout d'une accolade ouvrante au début du fichier
elif file_wished_input == "":
	file_wished = False
	print("Pas de fichier.")
complete_list = []
counter = len(pid_list)
for pid in pid_list:
	counter = counter - 1
	dataset_json = api.get_dataset(identifier = f"doi:{pid}").json()["data"] # export de la référence correspondant à 'pid'
	if '["latestVersion"]["files"]' in dataset_json:
		del (dataset_json["latestVersion"]["files"]) # suppression des métadonnées de fichiers
		print (f"Suppression des métadonnées de fichier dans l'export JSON du dataset {pid} ")
	elif '["latestVersion"]["files"]' not in dataset_json:
		print (f"Pas de métadonnées de fichier dans l'export JSON du dataset {pid}")
	else:
		print ("Le test de condition de présence de métadonnées de fichier ne fonctionne pas, vérifier le code!")
	complete_list.append(dataset_json) # ajout de la sortie json à une liste

	# Ecriture du fichier si l'utilisateur le souhaite
	if file_wished == True:
		print("Écriture du fichier JSON en cours...")
		formatted_dataset_json = json.dumps(dataset_json, sort_keys=False, indent=4)
		formatted_dataset_json_string = str (formatted_dataset_json) # Conversion en chaîne de caractères
		# formatted_dataset_json_string = f'"doi" : "{pid}" , "citation" : [{formatted_dataset_json_string}] ,'
		if counter > 0 : # Si c'est la dernière référence on ne met pas de virgule pour que le fichier JSON soit valide.
			formatted_dataset_json_string = f'"{pid}" : [{formatted_dataset_json_string}] ,' 
		elif counter == 0 :
			formatted_dataset_json_string = f'"{pid}" : [{formatted_dataset_json_string}] '
		
		with open (complete_list_file_name, 'a') as complete_list_file_object: 
			complete_list_file_object.write(formatted_dataset_json_string) # ecriture de la référence formattée dans le fichier de sortie
			complete_list_file_object.write("\n")

if file_wished == True : 
	with open (complete_list_file_name, 'a') as complete_list_file_object: # correction en mode bourrin du fichier de sortie
		complete_list_file_object.write("}")			# ajout d'une accolade fermante à la fin du fichier


# # Optionnellement, affichage de la liste complète finale (pour débogage)
# print_complete_list = input ("Voulez-vous voir la liste complète o/n ? (défaut n) ")
# if print_complete_list == "o":
# 	print (complete_list)
