# ===================================================================================
#        Génération de citations formatées sur la base d'un export JSON Dataverse
# ===================================================================================


print ("\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n")
print ("# ===========================================================================#")
print ("#             Génération de citations formatées sur la base                  #")
print ("#                      d'un export JSON Dataverse                            #")
print ("# ===========================================================================#")
print ("\n")

# Génération de citations selon le modèle décrit sur le site de Dataverse : 
# https://dataverse.org/best-practices/data-citation

# !!!!!!!!!!
# TODO
# - proposer différents styles de citations
# - accepter le nom de fichier comme argument en ligne de commande

# -----------------------
# Imports et déclarations
# -----------------------

import json
import os
from pyDataverse.api import NativeApi, DataAccessApi
from pyDataverse.models import Dataverse

# -------------------------------------
# Fonction de génération de la citation
# -------------------------------------

def citation_generation(cit_authors,cit_title,cit_year,cit_data_repository,cit_version_number,cit_version_minor_number,cit_doi,cit_unf):
	cit_authors_len = len(cit_authors)
	cit_authors_len_test = cit_authors_len
	citation = ""
	for cit_author in cit_authors:
		if cit_authors_len_test == cit_authors_len : # le nom du premier auteur est suivi d'un point-virgule, les autres d'une simple virgule
			citation += f"{cit_author}; "
		else:
			citation += f"{cit_author}, "
		cit_authors_len_test = cit_authors_len_test - 1
		

	if cit_year != "" :
		citation += f"{cit_year}, "
	else :
		citation += ""

	if cit_title != "" :
		citation += f"\"{cit_title}\", "
	else : 
		citation += ""

	if cit_data_repository != "" :
		citation += f"{cit_data_repository}, "
	else : 
		citation += ""

	citation += f"V{cit_version_number}.{cit_version_minor_number}, " # ajout de version
	
	if cit_doi !="" :
		citation += f"http://dx.doi.org/{cit_doi}"
	else : 
		citation += ""

	if cit_unf !="" :
		citation += f"UNF: {cit_unf}."
	else : 
		citation += ".\n"
	return (citation)


# ----------------
# Fichier d'entrée
# ----------------

# filename_input = input ("Entrez le nom du fichier à traiter [export_json.json] : ")
# if filename_input =="":
# 	filename = "export_json.json"
# else:
# 	filename = filename_input

filename = "export_json.json"

with open (filename) as f:
	complete_list = json.load(f)

bibliography_list = []

# --------------------------------------------------------------------------------
# Récupération des champs de métadonnées et génération de citation pour chaque DOI
# --------------------------------------------------------------------------------

for doi,metadata in complete_list.items(): # 
	print (f"\n\n\n{doi} : \n") # Retour du DOI. Décommenter pour débogage
	authors_list=[]
	subjects_list=[]

	metadata = metadata[0] # le dictionnaire étant enserré entre des crochets, on prend le premier et unique élément de cette "liste"
	# on récupère tout ce qu'on peut au niveau 1 de l'entrée et dans "latestVersion"
	
	dataset_id = metadata["id"]
	print (dataset_id)
	
	dataset_identifier = metadata["identifier"]
	# mapping de champs seulement s'ils existent (tests avec if)
	if "persistentUrl" in metadata :
		dataset_persistentUrl = metadata["persistentUrl"]
		print (dataset_persistentUrl)
	elif "persistentUrl" not in metadata :
		dataset_persistentUrl = ""
	else : 
		print ("Vérifier la partie du code concernant le mapping de persistentUrl")
	
	if "publicationDate" in metadata :
		dataset_publicationDate = metadata["publicationDate"]
		print (dataset_publicationDate)
	elif "publicationDate" not in metadata :
		dataset_publicationDate = ""
	else : 
		print ("Vérifier la partie du code concernant le mapping de publicationDate")

	dataset_yearofPublication = dataset_publicationDate[0:4]


	if "license" in metadata["latestVersion"] :
		dataset_license = metadata["latestVersion"]["license"]
		print (dataset_license)
	elif "license" not in metadata["latestVersion"] :
		dataset_license = ""
	else : 
		print ("Vérifier la partie du code concernant le mapping de license")

	if "publisher" in metadata :
		dataset_publisher = metadata["publisher"]
		print (dataset_publisher)
	elif "publisher" not in metadata :
		dataset_publisher = ""
	else : 
		print ("Vérifier la partie du code concernant le mapping de publisher")

	if "versionNumber" in metadata["latestVersion"] :
		dataset_versionNumber = metadata["latestVersion"]["versionNumber"]
		print (dataset_versionNumber)
	elif "versionNumber" not in metadata["latestVersion"] :
		dataset_versionNumber = ""
	else : 
		print ("Vérifier la partie du code concernant le mapping de versionNumber")

	if "versionMinorNumber" in metadata["latestVersion"] :
		dataset_versionMinorNumber = metadata["latestVersion"]["versionMinorNumber"]
		print (dataset_versionMinorNumber)
	elif "versionMinorNumber" not in metadata["latestVersion"] :
		dataset_versionMinorNumber = "0"
	else : 
		print ("Vérifier la partie du code concernant le mapping de versionMinorNumber")	

	if "UNF" in metadata["latestVersion"] :
		dataset_unf = metadata["latestVersion"]["UNF"]
		print (dataset_unf)
	elif "UNF" not in metadata["latestVersion"] :
		dataset_unf = ""
		print ("y a pas d'UNF et y a plus de ouisky!!!!")
	else :
		print ("Vérifier la partie du code concernant le mapping de UNF")

	
	fields = metadata["latestVersion"]["metadataBlocks"]["citation"]["fields"]
	for field in fields: # chaque champ est pris l'un après l'autre. field est un dictionnaire
		# print (field) 
		# print (f"{field['typeName']} : {field['value']}")
		typeName = field['typeName']
		# title = "" # on définit par avance l'ensemble des champs en leur attribuant une valeur vide
		# authors = ""
		# datasetContacts = ""
		# dsDescriptions = ""
		# subjects = ""
		# keywords = ""
		# languages = ""
		# depositors = ""
		# dateOfDeposit = ""
		if typeName == 'title':
			title = field['value'] # champ unique
		if typeName == 'author':
			authors = field['value'] # liste de dictionnaires donc chaque élément est un auteur
			for author in authors:
				authorName = author["authorName"]["value"]
				authors_list.append(authorName)
		if typeName == 'datasetContact':
			datasetContacts = field['value'] # champ multiple
		if typeName == 'dsDescription':
			dsDescriptions = field['value'] # champ multiple
		if typeName == 'subject':
			subjects = field['value'] # champ multiple
		if typeName == 'language':
			languages = field['value'] # liste
		if typeName == 'depositor':
			depositors = field['value']
		if typeName == 'keyword':
			keywords = field['value']
		if typeName == 'dateofDeposit':
			dateofDeposit = field['value']

	# Appel de la fonction de génération de citation

	citation_current = citation_generation(cit_authors = authors_list,cit_title=title,cit_year=dataset_yearofPublication,cit_data_repository=dataset_publisher,cit_version_number=dataset_versionNumber,cit_version_minor_number=dataset_versionMinorNumber, cit_doi=doi,cit_unf=dataset_unf)
	print (citation_current)
	bibliography_list.append(citation_current)

# -------------------------------------
# Génération de la bibliographie finale
# -------------------------------------

bibliography = ""
for reference in bibliography_list:
	bibliography += (f"{reference}\n")
export_filename_input = input ("Entrez un nom de fichier pour la sortie en format texte (défaut datasets_list.txt) : ")
if export_filename_input == "":
	export_filename = "datasets_list.txt"
else:
	export_filename = export_filename_input

with open(export_filename, 'w') as f:
	f.write(bibliography)







#  	