# scripts pyDataverse #

Several Python scripts using pyDataverse (https://pydataverse.readthedocs.io/en/latest/)
Written under v.3.10 but any python3 compatible with pyDataverse should work.

## Prerequisites ##
Python3 and pyDataverse must be installed.

## /dorel_export_v_0.2 ##
- citation_demo.sh : launches the two Python scripts one after the other. If default file names are kept when asked, can be played as a simple demo of an export.
- purge.sh : deletes the default files created (export_json.json and datasets_list.txt)
- get_batch_dataset_metadata_with_subcollections.py : gets every DOI from a Dataverse collection, including subcollections up to 4 sublevels, and outputs a JSON export of all of them.
- generate_citation.py : generates a text file with citations formatted as recommended by Dataverse, from the JSON file generated by the previous script (default file name same as default out : export_json.json)

## misc ##
- get_single_dataset_metadata.py : outputs a JSON export of a single dataset (not really useful, just here as reference)
- generate_tree : outputs the tree of a dataverse collection not unlike the "tree" API call in Dataverse 5.4+
- download_dataset : downloads an entire dataset based on the DOI. The directory structure is NOT preserved yet, so it's not of any use now.

## TODO ##
- make all scripts of dorel_export accept arguments from the command line
