import numpy as np
from ase.io import Trajectory
from dscribe.descriptors import SOAP
import os
import ase

class create_descriptor():
    def __init__(self,method='soap',params={'species':['Al','Co','H'],'l_max':2,'n_max':2,'r_cut':7},ats=0):
        self.ats=ats
        self.method=method
        if method == 'soap':
            self.decr=SOAP(periodic=True,**params)
            self.title=method+'_l'+str(params['l_max'])+'_n'+str(params['n_max'])+'_r'+str(params['r_cut'])
    def create(self,atoms,load=False,save_file=None):
        if load and os.path.exists(save_file+'/'+self.title+'.npy'):  
            X=np.load(save_file+'/'+self.title+'.npy')
        else:
            X=np.squeeze(self.decr.create(atoms,centers=[[self.ats]]*len(atoms)))
            if load:
                 np.save(save_file+'/'+self.title+'.npy',X)
        return X
    