"use strict";

import * as THREE from 'three';

import { OBJLoader } from 'three/addons/loaders/OBJLoader.js';
import { OrbitControls } from 'three/addons/controls/OrbitControls.js';
import {dat} from '/lib/dat.gui.min.js';
import {Coordinates} from './lib/Coordinates.js';
import renderer from "three/src/renderers/common/Renderer";

let camera, renderer;
let cameraControls;

let clock = new THREE.Clock();
let scene = new THREE.Scene();

/**
 *
 */
function fillScene() {

}

/**
 *
 */
function addToDOM() {
    let container = document.getElementById('webGL');
    let canvas = container.getElementsByTagName('canvas');
    if (canvas.length>0) {
        container.removeChild(canvas[0]);
    }
    container.appendChild( renderer.domElement);
}

/**
 *
 */
function init() {
    let canvasWidth = window.innerWidth;
    let canvasHeight = window.innerHeight;
    let canvasRatio = canvasWidth / canvasHeight;

    // RENDERER
    renderer = new THREE.WebGLRenderer( { antialias: true } );
    renderer.setSize(canvasWidth, canvasHeight);
    renderer.setClearColor( 0xFFFFFF, 1.0 );

    // Camera: Y up, X right, Z up
    camera = new THREE.PerspectiveCamera( 1, canvasRatio, 50, 150 );
    camera.position.set( 0.5, 0.5, 100 );

    // CONTROLS
    cameraControls = new OrbitControls(camera, renderer.domElement);
    cameraControls.target.set(0.5,0.5,0);

}

/**
 *
 */
function animate() {
    window.requestAnimationFrame(animate);
    render();
}

/**
 *
 */
function render() {
    let delta = clock.getDelta();
    cameraControls.update(delta);
    renderer.render(scene, camera);
}


try {
    init();
    fillScene();
    addToDOM();
    animate();
}
catch(e) {
    const errorReport = "Your program encountered an unrecoverable error, can not draw on canvas. Error was:<br/><br/>";
    $('#webGL').append(errorReport+e);
}